<?php
/* This file is part of BBClone (A PHP based Web Counter on Steroids)
 * 
 * SVN FILE $Id: nl.php 356 2015-12-11 10:49:19Z joku $
 *  
 * Copyright (C) 2001-2016, the BBClone Team (see doc/authors.txt for details)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * See doc/copying.txt for details
 */

// Language: Dutch (Nederlands)

// The DNS Extensions array
$extensions = array(
"localdomain" => "Lokaal",
"numeric" => "Numeriek",
"unknown" => "Onbekend",
"museum" => "Museum",
"travel" => "Reizen",
"ipv4" => "IPv4",
"ipv6" => "IPv6",

"aero" => "Luchtvaart",
"arpa" => "Arpanet oude stijl",
"asia" => "Azië en de Stille Oceaan",
"coop" => "Coöperatief",
"info" => "Informatie",
"jobs" => "Vacatures",
"mobi" => "Mobielen",
"name" => "Individu",
"post" => "Post",

"biz" => "Bedrijven",
"cat" => "Catalaans",
"com" => "Commercieel",
"edu" => "Educatieve instellingen VS",
"gal" => "Galicië",
"gov" => "Overheid VS",
"int" => "Internationaal",
"mil" => "Militair VS",
"net" => "Netwerken",
"org" => "Organisaties",
"pro" => "Professionals",
"tel" => "Contacten",
"xxx" => "Pornografie",

"a1" => "Anonieme Proxy",
"a2" => "Satellite Provider",
"ac" => "Ascension",
"ad" => "Andorra",
"ae" => "Verenigde Arabische Emiraten",
"af" => "Afghanistan",
"ag" => "Antigua en Barbuda",
"ai" => "Anguilla",
"al" => "Albanië",
"am" => "Armenië",
"an" => "Nederlandse Antillen",
"ao" => "Angola",
"ap" => "Azië en de Stille Oceaan",
"aq" => "Antarctica",
"ar" => "Argentinië",
"as" => "Amerikaans-Samoa",
"at" => "Oostenrijk",
"au" => "Australië",
"aw" => "Aruba",
"ax" => "Åland",
"az" => "Azerbeidzjan",
"ba" => "Bosnië en Herzegovina",
"bb" => "Barbados",
"bd" => "Bangladesh",
"be" => "België",
"bf" => "Burkina Faso",
"bg" => "Bulgarije",
"bh" => "Bahrein",
"bi" => "Burundi",
"bj" => "Benin",
"bm" => "Bermuda",
"bn" => "Brunei",
"bo" => "Bolivia",
"bq" => "Caribisch Nederland",
"br" => "Brazilië",
"bs" => "Bahama's",
"bt" => "Bhutan",
"bw" => "Botswana",
"by" => "Wit-Rusland",
"bz" => "Belize",
"ca" => "Canada",
"cc" => "Cocoseilanden",
"cd" => "Democratische Republiek Congo",
"cf" => "Centraal-Afrikaanse Republiek",
"cg" => "Congo",
"ch" => "Zwitserland",
"ci" => "Ivoorkust",
"ck" => "Cookeilanden",
"cl" => "Chili",
"cm" => "Kameroen",
"cn" => "China",
"co" => "Colombia",
"cr" => "Costa Rica",
"cu" => "Cuba",
"cv" => "Kaapverdië",
"cx" => "Christmaseiland",
"cy" => "Cyprus",
"cz" => "Tsjechië",
"de" => "Duitsland",
"dj" => "Djibouti",
"dk" => "Denemarken",
"dm" => "Dominica",
"do" => "Dominicaanse Republiek",
"dz" => "Algerije",
"ec" => "Ecuador",
"ee" => "Estland",
"eg" => "Egypte",
"er" => "Eritrea",
"es" => "Spainje",
"et" => "Ethiopië",
"eu" => "Europese Unie",
"fi" => "Finland",
"fj" => "Fiji",
"fk" => "Falklandeilanden",
"fm" => "Micronesia",
"fo" => "Faeröer",
"fr" => "Frankrijk",
"ga" => "Gabon",
"gd" => "Grenada",
"ge" => "Georgië",
"gf" => "Frans-Guyana",
"gg" => "Guernsey",
"gh" => "Ghana",
"gi" => "Gibraltar",
"gl" => "Groenland",
"gm" => "Gambia",
"gn" => "Guinee",
"gp" => "Guadeloupe",
"gq" => "Equatoriaal-Guinea",
"gr" => "Griekenland",
"gs" => "Zuid-Georgië en de Zuidelijke Sandwicheilanden",
"gt" => "Guatemala",
"gu" => "Guam",
"gw" => "Guinee-Bissau",
"gy" => "Guyana",
"hk" => "Hongkong",
"hm" => "Heard en MacDonaldeilanden",
"hn" => "Honduras",
"hr" => "Kroatië",
"ht" => "Haïti",
"hu" => "Hongarije",
"id" => "Indonesië",
"ie" => "Ierland",
"il" => "Israël",
"im" => "Eiland Man",
"in" => "India",
"io" => "Brits Indische Oceaanterritorium",
"iq" => "Irak",
"ir" => "Iran",
"is" => "IJsland",
"it" => "Italië",
"je" => "Jersey",
"jm" => "Jamaica",
"jo" => "Jordanië",
"jp" => "Japan",
"ke" => "Kenia",
"kg" => "Kirgizië",
"kh" => "Cambodja",
"ki" => "Kiribati",
"km" => "Comoren",
"kn" => "Saint Kitts en Nevis",
"kp" => "Noord-Korea",
"kr" => "Zuid-Korea",
"kw" => "Koeweit",
"ky" => "Kaaimaneilanden",
"kz" => "Kazachstan",
"la" => "Laos",
"lb" => "Lebanon",
"lc" => "Saint Lucia",
"li" => "Liechtenstein",
"lk" => "Sri Lanka",
"lr" => "Liberia",
"ls" => "Lesotho",
"lt" => "Litouwen",
"lu" => "Luxemburg",
"lv" => "Letland",
"ly" => "Libië",
"ma" => "Marokko",
"mc" => "Monaco",
"md" => "Moldavië",
"me" => "Montenegro",
"mg" => "Madagaskar",
"mh" => "Marshalleilanden",
"mk" => "Macedonië",
"ml" => "Mali",
"mm" => "Myanmar",
"mn" => "Mongolië",
"mo" => "Macau",
"mp" => "Noordelijke Marianen",
"mq" => "Martinique",
"mr" => "Mauritanië",
"ms" => "Montserrat",
"mt" => "Malta",
"mu" => "Mauritius",
"mv" => "Maldiven",
"mw" => "Malawi",
"mx" => "Mexico",
"my" => "Maleisië",
"mz" => "Mozambique",
"na" => "Namibië",
"nc" => "Nieuw-Caledonië",
"ne" => "Niger",
"nf" => "Norfolk",
"ng" => "Nigeria",
"ni" => "Nicaragua",
"nl" => "Nederland",
"no" => "Noorwegen",
"np" => "Nepal",
"nr" => "Nauru",
"nu" => "Niue",
"nz" => "Nieuw-Zeeland",
"om" => "Oman",
"pa" => "Panama",
"pe" => "Peru",
"pf" => "Frans-Polynesië",
"pg" => "Papoea-Nieuw-Guinea",
"ph" => "Filipijnen",
"pk" => "Pakistan",
"pl" => "Polen",
"pm" => "Saint-Pierre en Miquelon",
"pn" => "Pitcairneilanden",
"pr" => "Puerto Rico",
"ps" => "Palestina",
"pt" => "Portugal",
"pw" => "Palau",
"py" => "Paraguay",
"qa" => "Qatar",
"re" => "Réunion",
"ro" => "Roemenië",
"rs" => "Servië",
"ru" => "Rusland",
"rw" => "Rwanda",
"sa" => "Saoedi-Arabië",
"sb" => "Salomonseilanden",
"sc" => "Seychelles",
"sd" => "Soedan",
"se" => "Zweden",
"sg" => "Singapore",
"sh" => "Sint-Helena",
"si" => "Slovenië",
"sk" => "Slowakije",
"sl" => "Sierra Leone",
"sm" => "San Marino",
"sn" => "Senegal",
"so" => "Somalië",
"sr" => "Suriname",
"st" => "Sao Tomé en Principe",
"su" => "Sovjet-Unie",
"sv" => "El Salvador",
"sx" => "Sint Maarten",
"sy" => "Syrië",
"sz" => "Swaziland",
"tc" => "Turks- en Caicoseilanden",
"td" => "Tsjaad",
"tf" => "Franse Zuidelijke gebieden",
"tg" => "Togo",
"th" => "Thailand",
"tj" => "Tadzjikistan",
"tk" => "Tokelau",
"tl" => "Oost-Timor",
"tm" => "Turkmenistan",
"tn" => "Tunesië",
"to" => "Tonga",
"tp" => "Portugees Timor",
"tr" => "Turkije",
"tt" => "Trinidad en Tobago",
"tv" => "Tuvalu",
"tw" => "Taiwan",
"tz" => "Tanzania",
"ua" => "Oekraïne",
"ug" => "Oeganda",
"uk" => "Verenigd Koninkrijk",
"us" => "Verenigde Staten",
"uy" => "Uruguay",
"uz" => "Oezbekistan",
"va" => "Vaticaanstad",
"vc" => "Saint Vincent en de Grenadines",
"ve" => "Venezuela",
"vg" => "Britse Maagdeneilanden",
"vi" => "Amerikaanse Maagdeneilanden",
"vn" => "Vietnam",
"vu" => "Vanuatu",
"wf" => "Wallis en Futuna",
"ws" => "Samoa",
"ye" => "Jemen",
"yt" => "Mayotte",
"za" => "Zuid-Afrika",
"zm" => "Zambia",
"zw" => "Zimbabwe",

// No longer active but needed for history purpose
"bl" => "Saint Barthélemy",                    // Unassigned
"bv" => "Bouvet",                              // Inactive, but still in root (uses .no)
"bq" => "Caribbean Netherlands",               // Unassigned
"cs" => "Servië en Montenegro",                // Discontinued, No longer in root
"eh" => "Westelijke Sahara",                   // Unassigned
"gb" => "Groot-Brittannië",                    // Unused (uses .uk)
"mf" => "Sint-Maarten (Franse Antillen)",      // Unassigned
"sj" => "Spitsbergen en Jan Mayen-eilanden",   // Inactive, but still in root (uses .no)
"ss" => "Zuid-Soedan",                         // No longer in root
"um" => "Kleine afgelegen eilanden van de VS", // Discontinued, No longer in root
"yu" => "Servië en Montenegro",                // Discontinued, No longer in root
"zr" => "Zaire"                                // Discontinued, No longer in root
);

// The main Translation array
$translation = array(

// Specific charset
"global_charset" => "utf-8",

// Date format (used with date())
"global_time_format" => "j M, H:i:s",
"global_day_format" => "l j F Y",
"global_hours_format" => "l j F Y G:00",
"global_month_format" => "F Y",

// Global translation
"global_titlebar"=> "Statistieken voor %SERVER gegenereerd op %DATE",
"global_bbclone_copyright" => "Het BBClone Team - licentie onder de",
"global_last_reset" => "Statistieken laatst gewist op",
"global_yes" => "Ja",
"global_no" => "Nee",

// The error messages
"error_cannot_see_config" =>
"Het is op deze server niet toegestaan om de BBClone configuratie weer te geven.",

// Miscellaneous translations
"misc_other" => "Anders",
"misc_unknown" => "Onbekend",
"misc_second_unit" => "sec",
"misc_ignored" => "Genegeerd",

// The Navigation Bar
"navbar_main_site" => "Hoofdpagina",
"navbar_configuration" => "Instellingen",
"navbar_global_stats" => "Algemene Statistieken",
"navbar_detailed_stats" => "Gedetailleerde Statistieken",
"navbar_time_stats" => "Tijdstatistieken",
"navbar_language" => "Taal",
"navbar_go" => "Ga",

// Detailed Stats words
"dstat_id" => "ID",
"dstat_time" => "Tijdstip",
"dstat_visits" => "Bezoeken",
"dstat_extension" => "Land",
"dstat_dns" => "Hostnaam",
"dstat_from" => "Herkomst",
"dstat_os" => "Besturingssysteem",
"dstat_browser" => "Browser",
"dstat_visible_rows" => "Zichtbare bezoekers",
"dstat_search" => "Zoekwoord(en)",
"dstat_last_page" => "Laatste pagina",
"dstat_last_visit" => "Laatste bezoek",
"dstat_robots" => "Robots",
"dstat_my_visit" => "Bezoek via eigen IP",
"dstat_no_data" => "Geen gegevens beschikbaar",
"dstat_prx" => "Proxy Server",
"dstat_ip" => "IP adres",
"dstat_user_agent" => "User Agent",
"dstat_nr" => "Nr",
"dstat_pages" => "Pagina's",
"dstat_visit_length" => "Duur bezoek",
"dstat_reloads" => "Aantal keer herladen",
"dstat_whois_information" => "Zoek de informatie van dit IP adres op",

// Global Stats words
"gstat_accesses" => "Bezoekers",
"gstat_total_visits" => "Totaal aantal bezoekers",
"gstat_total_unique" => "Totaal aantal unieke bezoekers",
"gstat_operating_systems" => "Top %d Besturingssystemen",
"gstat_browsers" => "Top %d Browsers",
"gstat_extensions" => "Top %d Landen",
"gstat_robots" => "Top %d Robots",
"gstat_pages" => "Top %d Bezochte pagina's",
"gstat_origins" => "Top %d Herkomst",
"gstat_hosts" => "Top %d Hostnamen",
"gstat_keys" => "Top %d Zoekwoorden",
"gstat_total" => "Totaal",
"gstat_not_specified" => "Niet gespecificeerd",

// Time Stats words
"tstat_su" => "zo",
"tstat_mo" => "ma",
"tstat_tu" => "di",
"tstat_we" => "wo",
"tstat_th" => "do",
"tstat_fr" => "vr",
"tstat_sa" => "za",

"tstat_full_su" => "zondag",
"tstat_full_mo" => "maandag",
"tstat_full_tu" => "dinsdag",
"tstat_full_we" => "woensdag",
"tstat_full_th" => "donderdag",
"tstat_full_fr" => "vrijdag",
"tstat_full_sa" => "zaterdag",

"tstat_jan" => "Jan",
"tstat_feb" => "Feb",
"tstat_mar" => "Mrt",
"tstat_apr" => "Apr",
"tstat_may" => "Mei",
"tstat_jun" => "Jun",
"tstat_jul" => "Jul",
"tstat_aug" => "Aug",
"tstat_sep" => "Sep",
"tstat_oct" => "Okt",
"tstat_nov" => "Nov",
"tstat_dec" => "Dec",

"tstat_full_jan" => "Januari",
"tstat_full_feb" => "Februari",
"tstat_full_mar" => "Maart",
"tstat_full_apr" => "April",
"tstat_full_may" => "Mei",
"tstat_full_jun" => "Juni",
"tstat_full_jul" => "Juli",
"tstat_full_aug" => "Augustus",
"tstat_full_sep" => "September",
"tstat_full_oct" => "Oktober",
"tstat_full_nov" => "November",
"tstat_full_dec" => "December",

"tstat_last_day" => "Afgelopen 24 uur",
"tstat_last_week" => "Afgelopen week",
"tstat_last_month" => "Afgelopen maand",
"tstat_last_year" => "Afgelopen jaar",
"tstat_average" => "Gemiddeld",

// Loadtime notice
"generated" => "pagina gegenereerd in ",
"seconds" => "  seconden",

// Configuration page words and sentences
"config_variable_name" => "Naam variabele",
"config_variable_value" => "Waarde variabele",
"config_explanations" => "Uitleg",

"config_BBC_MAINSITE" =>
"Als deze variabele is ingesteld, zal een link naar de aangegeven locatie
worden gegenereerd. De standaardwaarde verwijst naar de bovenliggende folder.
In het geval dat de hoofd website een andere lokatie heeft, wil je waarschijnlijk
de waarde die hier genoemd staat aanpassen.<br />
Bijvoorbeeld:<br />
\$BBC_MAINSITE = &quot;http://www.myserver.com/&quot;;<br />
\$BBC_MAINSITE = &quot;..&quot;;<br />
\$BBC_MAINSITE = &quot;&quot;;",

"config_BBC_SHOW_CONFIG" =>
"BBClone laat standaard de instellingen van de statistieken zien. In het geval dit
gedrag niet gewenst is, kunt u toegang tot de instellingen ontzeggen
door deze optie te activeren.<br />
Bijvoorbeeld:<br />
\$BBC_SHOW_CONFIG = 1;<br />
\$BBC_SHOW_CONFIG = &quot;&quot;;",

"config_BBC_TITLEBAR" =>
"De titel van je statastieken pagina's.<br />
Het zal worden weergegeven in de titelbalk van alle BBClone pagina's<br />
De volgende variabelen kunnen hierbij worden gebruikt:<br />
<ul>
<li>%SERVER: server naam,</li>
<li>%DATE: huidige datum.</li>
</ul>
HTML-codes zijn toegestaan.<br />
Bijvoorbeeld:<br />
\$BBC_TITLEBAR = &quot;Statistieken voor %SERVER gegenereerd op %DATE&quot;;<br />
\$BBC_TITLEBAR = &quot;Mijn statistieken van %DATE zien eruit als:&quot;;<br />",

"config_BBC_LANGUAGE" =>
"BBClone's standaardtaal, indien deze niet wordt gespecificeerd door de browser.<br />
De volgende talen worden ondersteund (ISO taalcodes):
<p>ar, bg, bs, ca, cs, da, de, el, en, es, fi, fr, hu, id, it, ja, ko, lt, mk, nb,
nl, pl, pt, pt-br, ro, ru, sk, sl, sv, th, tr, ua, zh-cn and zh-tw</p>",

"config_BBC_MAXTIME" =>
"Deze variabele bepaalt de lengte van een unieke bezoeker in seconden. Elk bezoek
van dezelfde bezoeker binnen deze tijdsperiode zal gezien worden als een enkel bezoek,
zolang twee bezoeken niet hoger zijn dan de opgegeven limiet. De standaardinstelling
is 30 minuten (1800 seconden). Maar afhankelijk van uw behoeften, kunt u hier een
andere waarde toekennen.<br />
Bijvoorbeeld:<br />
\$BBC_MAXTIME = 0;<br />
\$BBC_MAXTIME = 1800;",

"config_BBC_MAXVISIBLE" =>
"Hoeveel regels die u in de gedetailleerde statistieken wilt laten zien? De
standaard waarde is 100. Geadviseerd wordt om deze waarde niet hoger dan 500 in te stellen,
dit om zware belasting van de server te voorkomen.",

"config_BBC_DETAILED_STAT_FIELDS" =>
"De variabele \$BBC_DETAILED_STAT_FIELDS bepaalt welke kolommen worden weergegeven
in de gedetailleerde statistieken. Mogelijke kolommen zijn:
<ul>
<li>id => De zoveelste bezoeker sinds het begin van tellen</li>
<li>time => Het tijdstip waarop het laatste bezoek geregistreerd is</li>
<li>visits => Aantal bezoeken van een unieke bezoeker</li>
<li>dns => Hostnaam van de bezoeker</li>
<li>ip => IP adres van de bezoeker</li>
<li>os => Het besturingssysteem (indien beschikbaar en/of robot)</li>
<li>browser => De software die gebruikt is voor de ​​connectie</li>
<li>ext => Herkomst (Land of extensie) van de bezoeker</li>
<li>referer => De link die een bezoeker hier bracht (indien beschikbaar)</li>
<li>page => De laatst bezochte pagina</li>
<li>search => Het zoekwoord dat gebruikt werd (indien beschikbaar)</li>
</ul>
De opgegeven volgorde zal ook worden gebruikt voor de weergave van de kolommen.<br />
Bijvoorbeeld:<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;id, time, visits, ip, ext, os, browser&quot;;
<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;date, ext, browser, os, ip&quot;;<br />",

"config_BBC_TIME_OFFSET" =>
"In geval de server tijd niet gelijk is aan de lokale tijdzone, kun je deze in minuten
aanpassen via deze variabele. Een negatieve waarden zal de tijd terug zetten, een
positieve waarden zet de tijd vooruit.<br />
Bijvoorbeeld:<br />
\$BBC_TIME_OFFSET = 300;<br />
\$BBC_TIME_OFFSET = -300;<br />
\$BBC_TIME_OFFSET = 0;",

"config_BBC_NO_DNS" =>
"Deze opties definieert of IP adres moeten worden omgezet naar een hostnaam of niet.
Hoewel een hostnaam meer verteld over de bezoeker. Het opzoeken hiervan kan uw website
aanzienlijk vertragen als de gebruikte DNS-server traag is, een beperkte capaciteit
heeft of uiterst onbetrouwbaar is. Door deze variabele te activeren kan dit mogelijk
het vertagings probleem oplossen.<br />
Bijvoorbeeld:<br />
\$BBC_NO_DNS = 1;<br />
\$BBC_NO_DNS = &quot;&quot;;",

"config_BBC_NO_HITS" =>
"Standaard zal BBClone alle bezoeken tonen in de tijd statistieken, want dit geeft
een vrij goede weergave van de serverbelasting. Maar als u unieke bezoeken wilt
gebruiken als basis voor uw tijd statistieken, kunt u de manier van tellen veranderen
door deze variabele in te stellen.<br />
Bijvoorbeeld:<br />
\$BBC_NO_HITS = 1;<br />
\$BBC_NO_HITS = &quot;&quot;;",

"config_BBC_IGNORE_IP" =>
"Deze optie kan worden gebruikt om bepaalde IP adressen of adres reeksen uit te sluiten
van de telling. In het geval dat u meerdere waardes wilt opgeven, scheid deze dan met
een komma.<br />
Bijvoorbeeld:<br />
\$BBC_IGNORE_IP = &quot;127., 192.168.&quot;;<br />
\$BBC_IGNORE_IP = &quot;&quot;;",

"config_BBC_IGNORE_REFER" =>
"In het geval u bepaalde verwijzingen van bezoekers niet in de gedetailleerde
statistieke wilt hebben, kunt u één of meerdere gebruikte zoekwoorden opgeven
voor het blokkeren van de verwijzing. Als u meerdere zoekwoorden gebruikt,
gebruik dan een komma om deze te scheiden.<br />
Bijvoorbeeld:<br />
\$BBC_IGNORE_REFER = &quot;spambot.org, .escort.&quot;;<br />
\$BBC_IGNORE_REFER = &quot;&quot;;",

"config_BBC_IGNORE_BOTS" =>
"Hoe robots worden behandelt, kunt u via deze optie regelen. De standaard is om
ze te negeren in de toplijsten, maar laat ze in de overige statistieken wel tonen.
Als u geen robots wilt zien, kunt uw deze optie op &quot;2&quot; zetten. Dan
zullen alleen menselijke bezoekers in aanmerking komen om geteld te worden.<br />
Bijvoorbeeld:<br />
\$BBC_IGNORE_BOTS = 2;<br />
\$BBC_IGNORE_BOTS = 1;<br />
\$BBC_IGNORE_BOTS = &quot;&quot;;",

"config_BBC_IGNORE_AGENT" =>
"Deze optie bepaalt hoe BBClone de ene bezoeker van de ander onderscheid.
Standaard wordt alleen het IP adres gebruikt, welke in de meeste gevallen
een realistisch beeld zal weergeven. Indien bezoekers zich schuil houden achter een
proxy server, kan het deactiveren van deze optie een realistischer beeld geven.
Aangezien een nieuwe bezoeker verondersteld word tegen de tijd dat de user agent
is veranderd<br />
Bijvoorbeeld:<br />
\$BBC_IGNORE_AGENT = 1;<br />
\$BBC_IGNORE_AGENT = &quot;&quot;;",

"config_BBC_KILL_STATS" =>
"Wanneer je de statistieken wilt wissen, kunt uw deze optie geactiveerd en zal
dit worden uitgevoerd bij het ​​volgende bezoek. Vergeet niet om achteraf deze te
deactiveren, anders zal men uitzonderlijk laag verkeer overhouden.<br />
Bijvoorbeeld:<br />
\$BBC_KILL_STATS = 1;<br />
\$BBC_KILL_STATS = &quot;&quot;;",

"config_BBC_PURGE_SINGLE" =>
"Herkomst statistieken kunnen grote hoeveelheid data genereren, hoewel dit meestal
wordt veroorzaakt door eenmalige bezoeken. Door het activeren van deze optie kun je
de statistieken opschonen en de grootte van access.php aanzienlijk verkleinen zonder
dat de rangschikking van zichtbare hostnamen en herkomsten te wijzigen. De eenmalige
bezoekers zullen worden toegevoegd aan &quot;not_specified&quot;. waardoor de totale
telling intact blijft.<br />
Bijvoorbeeld:<br />
\$BBC_PURGE_SINGLE = 1;<br />
\$BBC_PURGE_SINGLE = &quot;&quot;;",

"config_BBC_LOADTIME" =>
"Genereert de pagina laad-tijd in secondens aan de onderzijde van de pagina.<br />
Bijvoorbeeld:<br />
\$BBC_LOADTIME =&quot;&quot;;<br />
\$BBC_LOADTIME = 1;",

"config_BBC_EXT_LOOKUP" =>
"Deze opties definieert of een IP-adres wordt opgezocht om zo de locatie (land) te bepalen.<br />
Deze plug-ins zijn GEEN onderdeel van BBClone, houd hier rekening mee.<br />
<ul>
<li>IP2EXT => Gebruik de oude IP2EXT methode voor het opzoeken</li>
<li>GEOIP => Gebruik de GeoIP API plug-in</li>
<li>GEOIP-mod => Gebruik de GeoIP PHP/Perl Module (geoip.so)</li>
</ul>
Bijvoorbeeld:<br />
\$BBC_EXT_LOOKUP =&quot;&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;IP2EXT&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP-mod&quot;;",

"config_BBC_CSS_FILE" =>
"BBClone CSS bestandsnaam<br />
Let op; Binnen dit CSS-bestand kunt u het uiterlijk van BBClone veranderen<br />
(bijvoorbeeld het veranderen van de kleur of welke tekstgrootte/lettertype word gebruikt)<br />
Bijvoorbeeld:<br />
\$BBC_CSS_FILE =&quot;bbclone.css&quot;;<br />
\$BBC_CSS_FILE =&quot;other.css&quot;;",

"config_BBC_HITS" =>
"Deze optie geeft aan of ook de BBClone pagina's zelf geteld moeten worden binnen de statastieken.<br />
Bijvoorbeeld:<br />
\$BBC_HITS =1;<br />
\$BBC_HITS =&quot;&quot;;",

"config_BBC_USE_ORIGINAL_URI" =>
"Enable this option when the &quot;Top Visited Pages&quot; URI's are not working due
filtering of the URI. This can happen if you use BBClone with some Content
Management Systems (CMS) which are using very long (complex) URI naming.<br />
IMPORTED NOTE: This option changes how URI's are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_USE_ORIGINAL_URI = 1;	=> No filtering, use original URI<br />
\$BBC_USE_ORIGINAL_URI = &quot;&quot;;	=> Filter URI (default)",

"config_BBC_MAX_PAGENAME" =>
"The max. number of characters for the page name.<br />
Longer page names will be stript down at the front, leading with &quot;...&quot;<br />
IMPORTED NOTE: This option changes how page names are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_MAX_PAGENAME = 60;	=> 60 characters (default)"

);
?>
