<?php
/* This file is part of BBClone (A PHP based Web Counter on Steroids)
 * 
 * SVN FILE $Id: de.php 417 2022-12-21 11:27:14Z joku $
 *  
 * Copyright (C) 2001-2023, the BBClone Team (see doc/authors.txt for details)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * See doc/copying.txt for details
 */

// Language: German (Deutsch)

// The DNS Extensions array
$extensions = array(
"localdomain" => "Lokal",
"numeric" => "Numerisch",
"unknown" => "Unbekannt",
"museum" => "Museum",
"travel" => "Reisen",
"ipv4" => "IPv4",
"ipv6" => "IPv6",

"aero" => "Luftfahrt",
"arpa" => "Altes Arpnet",
"asia" => "Asien-Pazifik",
"coop" => "Kooperative",
"info" => "Auskunft",
"jobs" => "Jobs",
"mobi" => "Mobiles",
"name" => "Persönlich",
"post" => "Post",

"biz" => "Gewerbe",
"cat" => "Katalanisch",
"com" => "Unternehmen",
"edu" => "US Lehreinrichtungen",
"gal" => "Galicien",
"gov" => "US Regierungsbehörden",
"int" => "International",
"mil" => "US Streitkräfte",
"net" => "Netzwerke",
"org" => "Organisationen",
"pro" => "Professionell",
"tel" => "Kontakte",
"xxx" => "Erotik",

"a1" => "Anonymous Proxy",
"a2" => "Satellite Provider",
"ac" => "Ascension",
"ad" => "Andorra",
"ae" => "Vereinigte Arabische Emirate",
"af" => "Afghanistan",
"ag" => "Antigua und Barbuda",
"ai" => "Anguilla",
"al" => "Albanien",
"am" => "Armenien",
"an" => "Niederländische Antillen",
"ao" => "Angola",
"ap" => "Asien-Pazifik",
"aq" => "Antarktis",
"ar" => "Argentinien",
"as" => "Amerikanisch Samoa",
"at" => "Österreich",
"au" => "Australien",
"aw" => "Aruba",
"ax" => "Åland",
"az" => "Aserbaidschan",
"ba" => "Bosnien und Herzegowina",
"bb" => "Barbados",
"bd" => "Bangladesch",
"be" => "Belgien",
"bf" => "Burkina Faso",
"bg" => "Bulgarien",
"bh" => "Bahrain",
"bi" => "Burundi",
"bj" => "Benin",
"bm" => "Bermuda",
"bn" => "Brunei",
"bo" => "Bolivien",
"br" => "Brasilien",
"bs" => "Bahamas",
"bt" => "Bhutan",
"bw" => "Botswana",
"by" => "Weißrußland",
"bz" => "Belize",
"ca" => "Kanada",
"cc" => "Kokusinseln",
"cd" => "Kongo (Demokratische Republik)",
"cf" => "Zentralafrikanische Republik",
"cg" => "Kongo",
"ch" => "Schweiz",
"ci" => "Elfenbeinküste",
"ck" => "Cook Inseln",
"cl" => "Chile",
"cm" => "Kamerun",
"cn" => "China",
"co" => "Columbien",
"cr" => "Costa Rica",
"cu" => "Kuba",
"cv" => "Cap Verde",
"cw" => "Curaçao",
"cx" => "Weihnachtsinsel",
"cy" => "Zypern",
"cz" => "Tschechien",
"de" => "Deutschland",
"dj" => "Djibouti",
"dk" => "Dänemark",
"dm" => "Dominica",
"do" => "Dominikanische Republik",
"dz" => "Algerien",
"ec" => "Ecuador",
"ee" => "Estland",
"eg" => "Ägypten",
"er" => "Eritrea",
"es" => "Spanien",
"et" => "Äthiopien",
"eu" => "Europäische Union",
"fi" => "Finnland",
"fj" => "Fiji",
"fk" => "Falkland-Inseln",
"fm" => "Mikronesien",
"fo" => "Faroer",
"fr" => "Frankreich",
"ga" => "Gabun",
"gd" => "Grenada",
"ge" => "Georgien",
"gf" => "Französich Guayana",
"gg" => "Guernsey",
"gh" => "Ghana",
"gi" => "Gibraltar",
"gl" => "Grönland",
"gm" => "Gambia",
"gn" => "Guinea",
"gp" => "Guadalupe",
"gq" => "Äquatorial Guinea",
"gr" => "Griechenland",
"gs" => "Südgeorgien und Süd-Sandwich-Inseln",
"gt" => "Guatemala",
"gu" => "Guam",
"gw" => "Guinea-Bissau",
"gy" => "Guayana",
"hk" => "Hong Kong",
"hm" => "Heard und McDonald-Inseln",
"hn" => "Honduras",
"hr" => "Kroatien",
"ht" => "Haiti",
"hu" => "Ungarn",
"id" => "Indonesien",
"ie" => "Irland",
"il" => "Israel",
"im" => "Insel Man",
"in" => "Indien",
"io" => "UK Territorium im Indischen Ozean",
"iq" => "Irak",
"ir" => "Iran",
"is" => "Island",
"it" => "Italien",
"je" => "Jersey",
"jm" => "Jamaica",
"jo" => "Jordanien",
"jp" => "Japan",
"ke" => "Kenia",
"kg" => "Kirgisien",
"kh" => "Kambodscha",
"ki" => "Kiribati",
"km" => "Comoros",
"kn" => "St. Kitts und Nevis",
"kp" => "Nordkorea",
"kr" => "Korea",
"kw" => "Kuwait",
"ky" => "Kaimaninseln",
"kz" => "Kasachstan",
"la" => "Laos",
"lb" => "Libanon",
"lc" => "St. Lucia",
"li" => "Liechtenstein",
"lk" => "Sri Lanka",
"lr" => "Liberien",
"ls" => "Lesotho",
"lt" => "Litauen",
"lu" => "Luxemburg",
"lv" => "Lettland",
"ly" => "Libyen",
"ma" => "Marokko",
"mc" => "Monaco",
"md" => "Moldawien",
"me" => "Montenegro",
"mg" => "Madagaskar",
"mh" => "Marshall Inseln",
"mk" => "Mazedonien",
"ml" => "Mali",
"mm" => "Myanmar",
"mn" => "Mongolei",
"mo" => "Maçao",
"mp" => "Nördliche Marianneninseln",
"mq" => "Martinique",
"mr" => "Mauritanien",
"ms" => "Montserrat",
"mt" => "Malta",
"mu" => "Mauritius",
"mv" => "Malediwen",
"mw" => "Malawi",
"mx" => "Mexiko",
"my" => "Malaysia",
"mz" => "Mosambik",
"na" => "Namibia",
"nc" => "Neukaledonien",
"ne" => "Niger",
"nf" => "Norfolk-Inseln",
"ng" => "Nigeria",
"ni" => "Nicaragua",
"nl" => "Niederlande",
"no" => "Norwegen",
"np" => "Nepal",
"nr" => "Nauru",
"nu" => "Niue",
"nz" => "Neuseeland",
"om" => "Oman",
"pa" => "Panama",
"pe" => "Peru",
"pf" => "Französisch Polynesien",
"pg" => "Papua Neuguinea",
"ph" => "Philippinen",
"pk" => "Pakistan",
"pl" => "Polen",
"pm" => "St. Pierre und Miquelon",
"pn" => "Pitcairn",
"pr" => "Puerto Rico",
"ps" => "Palästina",
"pt" => "Portugal",
"pw" => "Palau",
"py" => "Paraguay",
"qa" => "Quatar",
"re" => "Reunion",
"ro" => "Rumänien",
"rs" => "Serbien",
"ru" => "Rußland",
"rw" => "Ruanda",
"sa" => "Saudi Arabien",
"sb" => "Solomoninseln",
"sc" => "Seychellen",
"sd" => "Sudan",
"se" => "Schweden",
"sg" => "Singapur",
"sh" => "St. Helena",
"si" => "Slowenien",
"sk" => "Slowakei",
"sl" => "Sierra Leone",
"sm" => "San Marino",
"sn" => "Senegal",
"so" => "Somalia",
"sr" => "Surinam",
"st" => "Sao Tome und Principe",
"su" => "Sowjetunion",
"sv" => "El Salvador",
"sx" => "Sint Maarten",
"sy" => "Syrien",
"sz" => "Swaziland",
"tc" => "Turks und Caicosinseln",
"td" => "Tschad",
"tf" => "Französische Südterritorien",
"tg" => "Togo",
"th" => "Thailand",
"tj" => "Tadschikistan",
"tk" => "Tokelau",
"tl" => "Ost-Timor",
"tm" => "Turkmenistan",
"tn" => "Tunesien",
"to" => "Tonga",
"tp" => "Ost-Timor",
"tr" => "Türkei",
"tt" => "Trinidad und Tobago",
"tv" => "Tuvalu",
"tw" => "Taiwan",
"tz" => "Tansania",
"ua" => "Ukraine",
"ug" => "Uganda",
"uk" => "Großbritannien",
"us" => "Vereinigte Staaten",
"uy" => "Uruguay",
"uz" => "Usbekistan",
"va" => "Vatikanstaat",
"vc" => "St. Vincent und die Grenadinen",
"ve" => "Venezuela",
"vg" => "Jungferninseln (UK)",
"vi" => "Jungferninseln (US)",
"vn" => "Vietnam",
"vu" => "Vanuatu",
"wf" => "Wallis und Futuna Inseln",
"ws" => "Samoa",
"ye" => "Jemen",
"yt" => "Mayotte",
"za" => "Südafrika",
"zm" => "Sambia",
"zw" => "Zimbabwe",

// No longer active but needed for history purpose
"bl" => "Saint Barthelemy",
"bv" => "Bouvet-Insel",
"bq" => "Karibischen Niederlande",
"cs" => "Serbien und Montenegro",
"eh" => "Westliche Sahara",
"gb" => "Großbritannien",
"mf" => "Saint Martin",
"sj" => "Svalbard und Jan-Mayen",
"ss" => "Südsudan",
"um" => "Kleine äußere Inseln der USA",
"yu" => "Serbien und Montenegro",
"zr" => "Zaire"
);

// The main Translation array
$translation = array(

// Specific charset
"global_charset" => "utf-8",

// Date format (used with date())
"global_time_format" => "j. M, H:i:s",
"global_day_format" => "l j. F Y",
"global_hours_format" => "l j. F Y G:00",
"global_month_format" => "F Y",

// Global translation
"global_titlebar"=> "Statistik für %SERVER generiert am %DATE",
"global_bbclone_copyright" => "Das BBClone Team - Lizensiert unter der",
"global_last_reset" => "Statistik zuletzt zurückgesetzt am",
"global_yes" => "ja",
"global_no" => "nein",

// The error messages
"error_cannot_see_config" =>
"Es ist Ihnen nicht gestattet, die Einstellungen von BBClone auf diesem Server einzusehen.",

// Miscellaneous translations
"misc_other" => "Sonstige",
"misc_unknown" => "Unbekannt",
"misc_second_unit" => "s",
"misc_ignored" => "Ignoriert",

// The Navigation Bar
"navbar_main_site" => "Hauptseite",
"navbar_configuration" => "Einstellungen",
"navbar_global_stats" => "Allgemeine Statistik",
"navbar_detailed_stats" => "Ausführliche Statistik",
"navbar_time_stats" => "Zeitstatistik",
"navbar_language" => "Sprache",
"navbar_go" => "Go",

// Detailed Stats words
"dstat_id" => "ID",
"dstat_time" => "Zuletzt",
"dstat_visits" => "Aufrufe",
"dstat_extension" => "Kennung",
"dstat_dns" => "Hostname",
"dstat_from" => "Gekommen von",
"dstat_os" => "BS",
"dstat_browser" => "Browser",
"dstat_visible_rows" => "Angezeigte Zugriffe",
"dstat_search" => "Suche",
"dstat_last_page" => "Letzte Seite",
"dstat_last_visit" => "letzter Aufruf",
"dstat_robots" => "Robots",
"dstat_my_visit" => "Aufrufe ihrer IP",
"dstat_no_data" => "Keine Daten verfügbar",
"dstat_prx" => "Proxy Server",
"dstat_ip" => "IP Adresse",
"dstat_user_agent" => "User Agent",
"dstat_nr" => "Nr",
"dstat_pages" => "Seiten",
"dstat_visit_length" => "Besuchsdauer",
"dstat_reloads" => "Neu geladen",
"dstat_whois_information" => "Informationen über diese IP Adresse",

// Global Stats words
"gstat_accesses" => "Zugriffe",
"gstat_total_visits" => "Aufrufe insgesamt",
"gstat_total_unique" => "Einmalige Aufrufe",
"gstat_operating_systems" => "Die ersten %d Betriebssysteme",
"gstat_browsers" => "Die ersten %d Browser",
"gstat_extensions" => "Die ersten %d Kennungen",
"gstat_robots" => "Die ersten %d Robots",
"gstat_pages" => "Die ersten %d Seiten",
"gstat_origins" => "Die ersten %d Herkünfte",
"gstat_hosts" => "Die ersten %d Hosts",
"gstat_keys" => "Die ersten %d Suchbegriffe",
"gstat_total" => "Insgesamt",
"gstat_not_specified" => "Keine Angaben",

// Time Stats words
"tstat_su" => "So",
"tstat_mo" => "Mo",
"tstat_tu" => "Di",
"tstat_we" => "Mi",
"tstat_th" => "Do",
"tstat_fr" => "Fr",
"tstat_sa" => "Sa",

"tstat_full_su" => "Sonntag",
"tstat_full_mo" => "Montag",
"tstat_full_tu" => "Dienstag",
"tstat_full_we" => "Mittwoch",
"tstat_full_th" => "Donnerstag",
"tstat_full_fr" => "Freitag",
"tstat_full_sa" => "Samstag",

"tstat_jan" => "Jan",
"tstat_feb" => "Feb",
"tstat_mar" => "Mär",
"tstat_apr" => "Apr",
"tstat_may" => "Mai",
"tstat_jun" => "Jun",
"tstat_jul" => "Jul",
"tstat_aug" => "Aug",
"tstat_sep" => "Sep",
"tstat_oct" => "Okt",
"tstat_nov" => "Nov",
"tstat_dec" => "Dez",

"tstat_full_jan" => "Januar",
"tstat_full_feb" => "Februar",
"tstat_full_mar" => "März",
"tstat_full_apr" => "April",
"tstat_full_may" => "Mai",
"tstat_full_jun" => "Juni",
"tstat_full_jul" => "Juli",
"tstat_full_aug" => "August",
"tstat_full_sep" => "September",
"tstat_full_oct" => "Oktober",
"tstat_full_nov" => "November",
"tstat_full_dec" => "Dezember",

"tstat_last_day" => "Bisheriger Tag",
"tstat_last_week" => "Bisherige Woche",
"tstat_last_month" => "Bisheriger Monat",
"tstat_last_year" => "Bisheriges Jahr",
"tstat_average" => "Durchschnittlich",

// Loadtime notice
"generated" => "Seite generiert in ",
"seconds" => " Sekunden",

// Configuration page words and sentences
"config_variable_name" => "Name der Variable",
"config_variable_value" => "Wert der Variable",
"config_explanations" => "Erläuterung",

"config_BBC_MAINSITE" =>
"Wenn diese Variable gesetzt ist, wird ein Link zum angegebenen Ziel erstellt.
Der Vorgabewert zeigt zum übergeordneten Verzeichnis. Falls sich Ihre
Hauptseite woanders befindet, möchten Sie vermutlich den Wert den
tatsächlichen Begebenheiten angleichen.
<br />
Beispiele:<br />
\$BBC_MAINSITE = &quot;http://www.meinserver.de/&quot;;<br />
\$BBC_MAINSITE = &quot;..&quot;;<br />
\$BBC_MAINSITE = &quot;&quot;;",

"config_BBC_SHOW_CONFIG" =>
"BBClone zeigt standardmäßig die Einstellungen der Statistik an.
Falls dies nicht erwünscht ist, können sie durch Deaktivieren der
Option den Zugriff sperren.<br />
Beispiele:<br />
\$BBC_SHOW_CONFIG = 1;<br />
\$BBC_SHOW_CONFIG = &quot;&quot;;",

"config_BBC_TITLEBAR" =>
"Der Titel Ihrer Statistikseite.<br />
Dieser wird in der Navigationsleiste aller BBClone Seiten angezeigt.<br />
Folgende Makros werden ausgewertet:<br />
<ul>
<li>%SERVER: Server Name,</li>
<li>%DATE: aktuelles Datum.</li>
</ul>
HTML Tags sind erlaubt.<br />
Beispiele:<br />
\$BBC_TITLEBAR = &quot;Statistik für %SERVER erstellt am %DATE&quot;;<br />
\$BBC_TITLEBAR = &quot;Meine Statistik vom %DATE sieht wie folgt aus:&quot;;
<br />",

"config_BBC_LANGUAGE" =>
"BBClones Standardsprache, falls diese nicht vom Browser angegeben wurde. Die
folgenden Sprachen werden unterstützt:
<p>ar, bg, bs, ca, cs, da, de, el, en, es, fi, fr, hu, id, it, ja, ko, lt, mk, nb,
nl, pl, pt, pt-br, ro, ru, sk, sl, sv, th, tr, ua, zh-cn und zh-tw</p>",

"config_BBC_MAXTIME" =>
"Diese Variable definiert die Dauer eines einmaligen Besuches in Sekunden.
Jeder Aufruf des gleichen Besuchers innerhalb dieses Zeitraumes wird als ein
Besuch behandelt, solange zwei aufeinanderfolgende Aufrufe nicht den
vorgegebenen Grenzwert überschreiten. Der Vorgabewert ist der de facto
Webstandard von 30 Minuten (1800 Sekunden), aber abhängig von Ihren
Bedürfnissen möchten Sie der Variablen vielleicht einen anderen Wert
zuweisen.<br />
Beispiele:<br />
\$BBC_MAXTIME = 0;<br />
\$BBC_MAXTIME = 1800;",

"config_BBC_MAXVISIBLE" =>
"Wieviele Einträge sollen in der ausfürlichen Statistik aufgelistet
werden? Der Standardwert ist 100. Es ist ratsam, diesen Wert nicht höher
als 500 zu setzen, um eine zu schwere Serverlast zu verhindern.",

"config_BBC_DETAILED_STAT_FIELDS" =>
"Die Variable \$BBC_DETAILED_STAT_FIELDS bestimmt die anzuzeigenden Spalten in
der ausfürlichen Statistik. Mögliche Spalten sind:
<ul>
<li>id => Der x-te Besucher seit dem Beginn des Zählens</li>
<li>time => Der Zeitpunkt, an dem der Besuch registriert wurde</li>
<li>visits => Die Aufrufe eines einmaligen Besuchers</li>
<li>dns => Hostname des Besuchers</li>
<li>ip => IP Adresse des Besuchers</li>
<li>os => dessen Betriebssystem (falls verfügbar und/oder kein Robot)</li>
<li>browser => Die für den Verbindungsaufbau verwendete Software</li>
<li>ext => Das Land oder die Kennung des Besuchers</li>
<li>referer => Der Link, welchem ein Besucher gefolgt ist (falls vorhanden)</li>
<li>page => Die zuletzt besuchte Seite</li>
<li>search => Die vom Besucher verwendeten Suchbegriffe (falls vorhanden)</li>
</ul>
Die gleiche Reihenfolge, in der Sie die Spalten anordnen, wird für die
Darstellung verwendet.<br />
Beispiele:<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;id, time, visits, ip, ext, os, browser&quot;;
<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;date, ext, browser, os, ip&quot;;<br />",

"config_BBC_TIME_OFFSET" =>
"Falls die Serverzeit nicht Ihrer lokalen Zeitzone entspricht, können sie
mit diesem Schalter die Zeit in Minuten angleichen. Negative Werte setzen die
Zeit zurück, positive stellen sie vor.<br />
Beispiele:<br />
\$BBC_TIME_OFFSET = 300;<br />
\$BBC_TIME_OFFSET = -300;<br />
\$BBC_TIME_OFFSET = 0;",

"config_BBC_NO_DNS" =>
"Diese Option legt fest, ob IP Adressen zu Hostnamen aufgelöst werden
sollen oder nicht. Während Hostnamen wesentlich mehr über den Besucher
aussagen, so kann doch das Auflösen zu Namen die Website beträchtlich
ausbremsen, sobald die verwendeten DNS Server langsam, begrenzt mit ihrer
Kapazität oder anderweitig unzuverlässig sind. Das Setzen dieser Variable
kann dieses Problem beheben.<br />
Beispiele:<br />
\$BBC_NO_DNS = 1;<br />
\$BBC_NO_DNS = &quot;&quot;;",

"config_BBC_NO_HITS" =>
"Das Standardverhalten von BBClone ist, Hits in der Zeitstatistik anzuzeigen,
weil dies recht guten Aufschluß über die tatsächliche
Serverauslastung gibt. Wenn Sie jedoch lieber einmalige Besuche als Grundlage
der Zeitstatistik verwenden möchten, können sie mit Setzen dieser
Variable den Zählmodus verändern.<br />
Beispiele:<br />
\$BBC_NO_HITS = 1;<br />
\$BBC_NO_HITS = &quot;&quot;;",

"config_BBC_IGNORE_IP" =>
"Diese Option kann verwendet werden, um bestimmte IP Adressen oder
Adressbereiche von der Zählung auszuschließen. Wenn sie mehrere
Ausdrücke aufführen wollen, verwenden Sie bitte ein Komma als
Trennzeichen.<br />
Beispiele:<br />
\$BBC_IGNORE_IP = &quot;127., 192.168.&quot;;<br />
\$BBC_IGNORE_IP = &quot;&quot;;",

"config_BBC_IGNORE_REFER" =>
"Falls Sie bestimmte Referrer Ihrer Besucher nicht in Ihrer Rangliste oder der
ausführlichen Statistik aufgeführt sehen möchten, können sie hier
ein oder mehrere Schlüsselbegriffe angeben, bei deren Vorkommen im
Referrer BBClone dessen Anzeige unterdrückt. Verwenden Sie bitte bei
mehreren Ausdrücken ein Komma als Trennzeichen.<br />
Beispiele:<br />
\$BBC_IGNORE_REFER = &quot;spambot.org, .escort.&quot;;<br />
\$BBC_IGNORE_REFER = &quot;&quot;;",

"config_BBC_IGNORE_BOTS" =>
"Sie können diese Option verwenden, um die Verfahrensweise bei Robots
festzulegen. Standard ist, diese in der Hosts Rangliste zu ignorieren, jedoch
in den restlichen Statistiken zu belassen. Falls sie überhaupt keine
Robots aufgelistet sehen möchten, können Sie diese Option auf
&quot;2&quot; setzen, dann werden nur Besuche von Menschen
berücksichtigt.<br />
Beispiele:<br />
\$BBC_IGNORE_BOTS = 2;<br />
\$BBC_IGNORE_BOTS = 1;<br />
\$BBC_IGNORE_BOTS = &quot;&quot;;",

"config_BBC_IGNORE_AGENT" =>
"Diese Option legt fest, auf welche Weise BBClone Besucher voneinander
unterscheidet. Standard ist nur die IP Adresse dafür zu verwenden, was in den
meisten Fällen für ein realistisches Zählen sorgt. Wenn jedoch Ihre Besucher
häufig hinter Proxyservern verborgen bleiben, könnte das Deaktivieren der
Option hier für realistischere Zahlen sorgen, weil dann bei jeder
Veränderung des User Agents von einem neuen Besucher ausgegangen wird.
<br />
Beispiele:<br />
\$BBC_IGNORE_AGENT = 1;<br />
\$BBC_IGNORE_AGENT = &quot;&quot;;",

"config_BBC_KILL_STATS" =>
"Jedesmal, wenn Sie Ihre Statisik zurücksetzen möchten, können
Sie dafür diese Option verwenden und sie mit dem nächsten Zugriff
unwiderbringlich löschen lassen. Sie sollten allerdings danach nicht
vergessen, die Option wieder zu deaktivieren, sonst werden Sie vermutlich
ungewöhnlich wenig Traffic in nächster Zeit haben ;).<br />
Beispiele:<br />
\$BBC_KILL_STATS = 1;<br />
\$BBC_KILL_STATS = &quot;&quot;;",

"config_BBC_PURGE_SINGLE" =>
"Die Host und Referrer Statistik kann eine Menge Daten erzeugen, die jedoch
meist von einmaligen Besuchern stammen. Durch das Aktivieren dieser Option
können sie diese Einträge entfernen und somit die Größe
von access.php beträchtlich verringern, ohne daß Ihre sichtbare
Rangordnung der Hosts und Referrer davon berührt werden. Die Summe der
Zugriffe wird dann zu den &quot;keine Angaben&quot; hinzugezählt, damit
der insgesamte Zählerstand in sich stimmig bleibt.<br />
Beispiele:<br />
\$BBC_PURGE_SINGLE = 1;<br />
\$BBC_PURGE_SINGLE = &quot;&quot;;",

"config_BBC_LOADTIME" =>
"Erstellt die Seiten Ladezeit in Sekunden unten auf der Seite<br />
Beispiele:<br />
\$BBC_LOADTIME =&quot;&quot;;<br />
\$BBC_LOADTIME = 1;",

"config_BBC_EXT_LOOKUP" =>
"Diese Einstellung legt fest, wie die IP Adresse ausgewertet wird, Land oder IP.<br />
GeoIP und IP2EXT sind nicht Bestandteil von BBClone.<br />
<ul>
<li>IP2EXT => benutzt IP2EXT</li>
<li>GEOIP => benutzt GeoIP API plug-in</li>
<li>GEOIP-mod => benutzt GeoIP PHP/Perl Module (geoip.so)</li>
</ul>
Beispiele:<br />
\$BBC_EXT_LOOKUP =&quot;&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;IP2EXT&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP-mod&quot;;",

"config_BBC_CSS_FILE" =>
"BBClone CSS File Name<br />
Mit dieser CSS Datei lassen sich die Ansicht von BBClone einstellen.<br />
(zum Beispiel: die Farben, Textgröße und Fonts die verwendet werden)<br />
Beispiele:<br />
\$BBC_CSS_FILE =&quot;bbclone.css&quot;;<br />
\$BBC_CSS_FILE =&quot;other.css&quot;;",

"config_BBC_HITS" =>
"BBClone zählt seine eigenen Seiten<br />
Beispiele:<br />
\$BBC_HITS =1;<br />
\$BBC_HITS =&quot;&quot;;",

"config_BBC_USE_ORIGINAL_URI" =>
"Aktivieren Sie diese Option, wenn die &quot;Die ersten besuchten Seiten&quot; URI's nicht funktionieren auf Grund der Filterung der UR. Dies kann passieren wenn Sie BBClone mit Content
Management Systems (CMS) verwenden, welche sehr lange (complex) URI Namen verwenden.<br />
HINWEISS: Diese Option ändert die Aufzeichnug der URL.<br />
Es muss die Statistik eventuell zurückgesetzt werden.<br />
Beispiele:<br />
\$BBC_USE_ORIGINAL_URI = 1;	=> No filtering, use original URI<br />
\$BBC_USE_ORIGINAL_URI = &quot;&quot;;	=> Filter URI (default)",

"config_BBC_MAX_PAGENAME" =>
"Die maximale Anzahl der Zeichen für den Seitennamen.<br />
Lange Seitennamen werden gekürzt, führend mit &quot;...&quot;<br />
HINWEISS: Diese Option änder die Seitenanzeige,<br />
wie die Seitennamen gespeichert werden,<br />
es muss die Statistik eventuell zurückgesetzt werden.<br />
Beispiele:<br />

\$BBC_MAX_PAGENAME = 60;	=> 60 characters (default)"

);
?>
