<?php
/* This file is part of BBClone (A PHP based Web Counter on Steroids)
 * 
 * SVN FILE $Id: pt-br.php 417 2022-12-21 11:27:14Z joku $
 *  
 * Copyright (C) 2001-2023, the BBClone Team (see doc/authors.txt for details)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * See doc/copying.txt for details
 */

// Language: Brazilian Portuguese (Português do Brasil)

// The DNS Extensions array
$extensions = array(
"localdomain" => "Local",
"numeric" => "Numérico",
"unknown" => "Desconhecido",
"museum" => "Museu",
"travel" => "Travel",
"ipv4" => "IPv4",
"ipv6" => "IPv6",

"aero" => "Aero",
"arpa" => "Enganos",
"asia" => "Asia-Pacifico",
"coop" => "Coop",
"info" => "Informações",
"jobs" => "Emprego",
"mobi" => "Mobiles",
"name" => "Personal",
"post" => "Serviços Postais",

"biz" => "negócio",
"cat" => "Catalan",
"com" => "Comercial",
"edu" => "Educacional",
"gal" => "Galician",
"gov" => "Governo",
"int" => "Organizações Internacionais",
"mil" => "Militar dos EUA",
"net" => "Redes",
"org" => "Organizações",
"pro" => "Professional",
"tel" => "Contactos",
"xxx" => "Pornográfico",

"a1" => "Anonymous Proxy",
"a2" => "Satellite Provider",
"ac" => "Ilha Ascenção",
"ad" => "Andorra",
"ae" => "Emirados Árabes Unidos",
"af" => "Afeganistão",
"ag" => "Antígua and Barbuda",
"ai" => "Anguilla",
"al" => "Albânia",
"am" => "Armênia",
"an" => "Antilhas Holandesas",
"ao" => "Angola",
"ap" => "Asia-Pacifico",
"aq" => "Antarctica",
"ar" => "Argentina",
"as" => "Samoa Americana",
"at" => "Áustria",
"au" => "Australia",
"aw" => "Aruba",
"ax" => "Åland",
"az" => "Azerbaijão",
"ba" => "Bosnia e Herzegovina",
"bb" => "Barbados",
"bd" => "Bangladesh",
"be" => "Belgica",
"bf" => "Burkina Faso",
"bg" => "Bulgária",
"bh" => "Bahrain",
"bi" => "Burundi",
"bj" => "Benin",
"bm" => "Bermuda",
"bn" => "Brunei",
"bo" => "Bolívia",
"br" => "Brasil",
"bs" => "Bahamas",
"bt" => "Butão",
"bw" => "Botsuana",
"by" => "Belarus",
"bz" => "Belize",
"ca" => "Canadá",
"cc" => "Ilhas Cocos",
"cd" => "Congo",
"cf" => "Republica da África Central",
"cg" => "Congo",
"ch" => "Suíca",
"ci" => "Costa do Marfim",
"ck" => "Ilhas Cook",
"cl" => "Chile",
"cm" => "Camarões",
"cn" => "China",
"co" => "Colômbia",
"cr" => "Costa Rica",
"cu" => "Cuba",
"cv" => "Cabo Verde",
"cw" => "Curaçao",
"cx" => "Ilhas Natal",
"cy" => "Chipre",
"cz" => "República Czech",
"de" => "Alemanha",
"dj" => "Djibuti",
"dk" => "Dinamarca",
"dm" => "Dominica",
"do" => "República Dominicana",
"dz" => "Algéria",
"ec" => "Equador",
"ee" => "Estônia",
"eg" => "Egito",
"er" => "Eritréa",
"es" => "Espanha",
"et" => "Etiópia",
"eu" => "European Union",
"fi" => "Finlândia",
"fj" => "Fiji",
"fk" => "Ilhas Falkland",
"fm" => "Micronesia",
"fo" => "Ilhas Faroe",
"fr" => "França",
"ga" => "Gabão",
"gd" => "Granada",
"ge" => "Georgia",
"gf" => "Guiana Francesa",
"gg" => "Guernsey",
"gh" => "Gana",
"gi" => "Gibraltar",
"gl" => "Groelândia",
"gm" => "Gâmbia",
"gn" => "Guiné",
"gp" => "Guadalupe",
"gq" => "Guiné Equatorial",
"gr" => "Grecia",
"gs" => "Ilhas Sul Georgia e Ilhas Sul Sandwich",
"gt" => "Guatemala",
"gu" => "Guam",
"gw" => "Guiné-Bissau",
"gy" => "Guiana",
"hk" => "Hong Kong",
"hm" => "Ilhas Heard e Mc Donald",
"hn" => "Honduras",
"hr" => "Croácia",
"ht" => "Haiti",
"hu" => "Hungria",
"id" => "Indonésia",
"ie" => "Irlanda",
"il" => "Israel",
"im" => "Ilha do Homem",
"in" => "Índia",
"io" => "Território Britânico no Oceano Índico",
"iq" => "Iraque",
"ir" => "Irã",
"is" => "Iceland",
"it" => "Italia",
"je" => "Jersey",
"jm" => "Jamaica",
"jo" => "Jordânia",
"jp" => "Japão",
"ke" => "Quênia",
"kg" => "Quirguiquistão",
"kh" => "Cambodja",
"ki" => "Kiribati",
"km" => "Comoros",
"kn" => "Saint Kitts and Nevis",
"kp" => "North Korea",
"kr" => "Coréia",
"kw" => "Kuwait",
"ky" => "Ilhas Caimam",
"kz" => "Casaquistão",
"la" => "Laos",
"lb" => "Líbano",
"lc" => "Santa Lúcia",
"li" => "Liechtenstein",
"lk" => "Sri Lanka",
"lr" => "Libéria",
"ls" => "Lesoto",
"lt" => "Litônia",
"lu" => "Luxemburgo",
"lv" => "Latvia",
"ly" => "Líbia",
"ma" => "Morrocos",
"mc" => "Mônaco",
"md" => "Moldávia",
"me" => "Montenegro",
"mg" => "Madagascar",
"mh" => "Ilhas Marshall",
"mk" => "Macedônia",
"ml" => "Mali",
"mm" => "Myanmar",
"mn" => "Mongólia",
"mo" => "Macau",
"mp" => "Ilhas Mariana do Norte",
"mq" => "Martinica",
"mr" => "Mauritania",
"ms" => "Montserrat",
"mt" => "Malta",
"mu" => "Mauritania",
"mv" => "Maldivas",
"mw" => "Malauí",
"mx" => "México",
"my" => "Malasia",
"mz" => "Moçambique",
"na" => "Namíbia",
"nc" => "Nova Caledonia",
"ne" => "Níger",
"nf" => "Ilha Norfolk",
"ng" => "Nigeria",
"ni" => "Nicarágua",
"nl" => "Holanda",
"no" => "Noruega",
"np" => "Nepal",
"nr" => "Nauru",
"nu" => "Niue",
"nz" => "Nova Zelandia",
"om" => "Omã",
"pa" => "Panamá",
"pe" => "Peru",
"pf" => "Polinésia Francesa",
"pg" => "Papua Nova Guiné",
"ph" => "Filipinas",
"pk" => "Paquistão",
"pl" => "Polônia",
"pm" => "St. Pierre e Miquelon",
"pn" => "Pitcairn",
"pr" => "Porto Rico",
"ps" => "Palestina",
"pt" => "Portugal",
"pw" => "Palau",
"py" => "Paraguai",
"qa" => "Qatar",
"re" => "Reunião",
"ro" => "Romênia",
"rs" => "Serbia",
"ru" => "Federação Russa",
"rw" => "Ruanda",
"sa" => "Arábia Saudita",
"sb" => "Ilhas Salomão",
"sc" => "Seycheles",
"sd" => "Sudão",
"se" => "Suécia",
"sg" => "Singapura",
"sh" => "St. Helena",
"si" => "Eslovênia",
"sk" => "Eslováquia",
"sl" => "Serra Leoa",
"sm" => "San Marino",
"sn" => "Senegal",
"so" => "Somália",
"sr" => "Suriname",
"st" => "São Tomé e Préncipe",
"su" => "União Soviética",
"sv" => "El Salvador",
"sx" => "Sint Maarten",
"sy" => "Síria",
"sz" => "Suazilandia",
"tc" => "Ilhas Turks e Caicos",
"td" => "Chade",
"tf" => "Território do Sul da França",
"tg" => "Togo",
"th" => "Tailândia",
"tj" => "Tajiquistão",
"tk" => "Tokelau",
"tl" => "Timor Leste",
"tm" => "Turcomenistão",
"tn" => "Tunísia",
"to" => "Tonga",
"tp" => "Timor Leste",
"tr" => "Turquia",
"tt" => "Trinidad e Tobago",
"tv" => "Tuvalu",
"tw" => "Taiwan",
"tz" => "Tanzânia",
"ua" => "Ucrânia",
"ug" => "Uganda",
"uk" => "Reino Unido",
"us" => "Estados Unidos",
"uy" => "Uruguai",
"uz" => "Usbequistão",
"va" => "Estado do Vaticano",
"vc" => "St. Vincent e Grenadines",
"ve" => "Venezuela",
"vg" => "Ilhas Virges (UK)",
"vi" => "Ilhas Virgens (EUA)",
"vn" => "Vietnã",
"vu" => "Vanuatu",
"wf" => "Ilhas Wallis e Futuna",
"ws" => "Samoa",
"ye" => "Iêmen",
"yt" => "Mayotte",
"za" => "África do Sul",
"zm" => "Zâmbia",
"zw" => "Zimbábue",

// No longer active but needed for history purpose
"bl" => "São Bartolomeu",
"bv" => "Ilha Bouvet",
"bq" => "Caribe Holanda",
"cs" => "Sérvia e Montenegro",
"eh" => "Saara Ocidental",
"gb" => "Grã-Bretanha",
"mf" => "Saint-Martin",
"sj" => "Ilhas Svalbard e Jan Mayen",
"ss" => "Sudão do Sul",
"um" => "Ilhas menores dos EUA",
"yu" => "Sérvia e Montenegro",
"zr" => "Zaire"
);

// The main Translation array
$translation = array(

// Specific charset
"global_charset" => "utf-8",

// Global translation
"global_titlebar"=> "Estatísticas de %SERVER, geradas em %DATE",
"global_bbclone_copyright" => "O time BBClone - Distribuído sob a Licença",
"global_last_reset" => "Statistics last reset on",
"global_yes" => "Sim",
"global_no" => "Não",

// The error messages
"error_cannot_see_config" =>
"Não é permitido ver a configuração do BBClone configuration neste servidor.",

// Date format (used with date())
"global_time_format" => "M jS, H:i:s",
"global_day_format" => "l F jS, Y",
"global_hours_format" => "l F jS, G:00",
"global_month_format" => "F Y",

// Miscellaneous translations
"misc_other" => "Outro",
"misc_unknown" => "Desconhecido",
"misc_second_unit" => "s",
"misc_ignored" => "Ignorado",

// The Navigation Bar
"navbar_main_site" => "Página Principal",
"navbar_configuration" => "Configuração",
"navbar_global_stats" => "Estatísticas Globais",
"navbar_detailed_stats" => "Estatísticas Detalhadas",
"navbar_time_stats" => "Estatísticas Cronológicas",
"navbar_language" => "Lingua",
"navbar_go" => "ir",

// Detailed Stats words
"dstat_id" => "ID",
"dstat_time" => "Tempo",
"dstat_visits" => "Visitas",
"dstat_extension" => "Extensão",
"dstat_dns" => "Hostname",
"dstat_from" => "De",
"dstat_os" => "OS",
"dstat_browser" => "Navegador",
"dstat_visible_rows" => "Acessos visíveis",
"dstat_green_rows" => "linhas verdes",
"dstat_blue_rows" => "linhas azuis",
"dstat_red_rows" => "linhas vermelhas",
"dstat_search" => "Busca",
"dstat_last_page" => "última página",
"dstat_last_visit" => "última visita",
"dstat_robots" => "robôs",
"dstat_my_visit" => "Visitas a partir do seu IP",
"dstat_no_data" => "Sem dados disponíveis",
"dstat_prx" => "Servidor de Proximidade",
"dstat_ip" => "Endereço IP",
"dstat_user_agent" => "Pormenores do Navegador Utilizado",
"dstat_nr" => "Nº",
"dstat_pages" => "Páginas",
"dstat_visit_length" => "Duração da Visita",
"dstat_reloads" => "Recargas",
"dstat_whois_information" => "Procure informações sobre este endereço IP",

// Global Stats words
"gstat_accesses" => "Acessos",
"gstat_total_visits" => "Total visitas",
"gstat_total_unique" => "Total únicas",
"gstat_operating_systems" => "Sistemas operacionais: %d Mais",
"gstat_browsers" => "Navegadores: %d Mais",
"gstat_extensions" => "Extensões: %d Mais",
"gstat_robots" => "Robôs: %d Mais",
"gstat_pages" => "Páginas Visitadas: %d Mais",
"gstat_origins" => "Origens: %d Mais",
"gstat_hosts" => "Top %d Hosts",
"gstat_keys" => "Top %d Keywords",
"gstat_total" => "Total",
"gstat_not_specified" => "Não especificado",

// Time Stats words
"tstat_su" => "Dom",
"tstat_mo" => "Seg",
"tstat_tu" => "Ter",
"tstat_we" => "Qua",
"tstat_th" => "Qui",
"tstat_fr" => "Sex",
"tstat_sa" => "Sáb",

"tstat_full_su" => "Domingo",
"tstat_full_mo" => "Monday",
"tstat_full_tu" => "terça-feira",
"tstat_full_we" => "Quarta",
"tstat_full_th" => "quinta-feira",
"tstat_full_fr" => "Friday",
"tstat_full_sa" => "Sábado",

"tstat_jan" => "Jan",
"tstat_feb" => "Feb",
"tstat_mar" => "Mar",
"tstat_apr" => "Abr",
"tstat_may" => "Mai",
"tstat_jun" => "Jun",
"tstat_jul" => "Jul",
"tstat_aug" => "Ago",
"tstat_sep" => "Set",
"tstat_oct" => "Out",
"tstat_nov" => "Nov",
"tstat_dec" => "Dez",

"tstat_full_jan" => "Janeiro",
"tstat_full_feb" => "Fevereiro",
"tstat_full_mar" => "Março",
"tstat_full_apr" => "Abril",
"tstat_full_may" => "Maio",
"tstat_full_jun" => "Junho",
"tstat_full_jul" => "Julho",
"tstat_full_aug" => "Agosto",
"tstat_full_sep" => "Setembro",
"tstat_full_oct" => "Outubro",
"tstat_full_nov" => "Novembro",
"tstat_full_dec" => "December",

"tstat_last_day" => "Último dia",
"tstat_last_week" => "Última semana",
"tstat_last_month" => "Último mês",
"tstat_last_year" => "Último ano",
"tstat_average" => "média",

// Loadtime notice
"generated" => "Página gerada em ",
"seconds" => " segundos",

// Configuration page words and sentences
"config_variable_name" => "Nome da Variável",
"config_variable_value" => "Valor da Variável",
"config_explanations" => "Explanações",

// needs to be translated
"config_BBC_MAINSITE" =>
"If this variable has been set, a link to the specified location will be
generated. The default value is pointing to the parent directory. In case your
main site is located elsewhere, you probably want to adjust the value to suit
your needs.<br />
Examples:<br />
\$BBC_MAINSITE = &quot;http://www.myserver.com/&quot;;<br />
\$BBC_MAINSITE = &quot;..&quot;;<br />
\$BBC_MAINSITE = &quot;&quot;;",

"config_BBC_SHOW_CONFIG" =>
"BBClone defaults to revealing the stats' settings. In case this behavior isn't
desired you can deny access to it by deactivating the option.<br />
Examples:<br />
\$BBC_SHOW_CONFIG = 1;<br />
\$BBC_SHOW_CONFIG = &quot;&quot;;",

"config_BBC_TITLEBAR" =>
"O título aparecendo dentro da barra de título presente em todas páginas do BBClone.<br />
Variáveis reconhecíveis são:<br />
<ul>
<li>%SERVER: nome do servidor,</li>
<li>%DATE: a data corrente.</li>
</ul>
HTML tags são também permitidas.<br />
Examples:<br />
\$BBC_TITLEBAR = &quot;Statistics for %SERVER generated the %DATE&quot;;<br />
\$BBC_TITLEBAR = &quot;My stats from %DATE look like this:&quot;;
<br />",

"config_BBC_LANGUAGE" =>
"BBClone's default language, in case it hasn't been specified by the browser.
The following languages are supported:
<p>ar, bg, bs, ca, cs, da, de, el, en, es, fi, fr, hu, id, it, ja, ko, lt, mk, nb,
nl, pl, pt, pt-br, ro, ru, sk, sl, sv, th, tr, ua, zh-cn and zh-tw</p>",

"config_BBC_MAXTIME" =>
"This variable defines the length of an unique visit in seconds. Each hit from
the same visitor within this period will be considered as one visit, as long as
two successive hits don't exceed the specified limit. Default is the de facto
web standard of 30 minutes (1800 seconds), but depending on your needs you may
wish to assign a different value.<br />
Examples:<br />
\$BBC_MAXTIME = 0;<br />
\$BBC_MAXTIME = 1800;",

"config_BBC_MAXVISIBLE" =>
"How many entries you want to have listed in the detailed stats? The default
value is 100. It's recommended not to set it higher than 500 to avoid too heavy
load.",

"config_BBC_DETAILED_STAT_FIELDS" =>
"The variable \$BBC_DETAILED_STAT_FIELDS determines the columns to be displayed
in the detailed statistics. Possible columns are:
<ul>
<li>id => The x-th visitor since you've started counting</li>
<li>time => The time at which the last hit was registerred</li>
<li>visits => The hits of one unique visitor</li>
<li>dns => Visitor's hostname</li>
<li>ip => Visitor's IP address</li>
<li>os => The operating system (if available and/or no robot)</li>
<li>browser => The software used for establishing the connection</li>
<li>ext => Visitor's country or extension</li>
<li>referer => The link from which a visitor came (if available)</li>
<li>page => The last visited page</li>
<li>search => The search query a visitor used (if available)</li>
</ul>
The same order you've arranged the columns will be used for display.<br />
Examples:<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;id, time, visits, ip, ext, os, browser&quot;;
<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;date, ext, browser, os, ip&quot;;<br />",

"config_BBC_TIME_OFFSET" =>
"In case the server time doesn't match your local timezone, you can adjust the
time in minutes by using this switch. Negative values will set back the time,
positive ones will set it forth.<br />
Examples:<br />
\$BBC_TIME_OFFSET = 300;<br />
\$BBC_TIME_OFFSET = -300;<br />
\$BBC_TIME_OFFSET = 0;",

"config_BBC_NO_DNS" =>
"This options defines, whether IP addresses should be resolved to hostnames or
not. While hostnames tell a lot more about the visitor, resolving them may
considerably slow down your site, if the DNS servers used are slow, limited in
their capacity or otherwise unreliable. Setting this variable may solve the
problem.<br />
Examples:<br />
\$BBC_NO_DNS = 1;<br />
\$BBC_NO_DNS = &quot;&quot;;",

"config_BBC_NO_HITS" =>
"BBClone's default is to show hits in the time stats, because it gives a quite
useful Impression from the actual server load. If, however, you prefer to use
unique visits as base for your time stats, you can change the way of counting
by setting this variable.<br />
Examples:<br />
\$BBC_NO_HITS = 1;<br />
\$BBC_NO_HITS = &quot;&quot;;",

"config_BBC_IGNORE_IP" =>
"This option can be used to exclude particular IP addresses or address ranges
from counting. In case you want to add several expressions use a comma as
separator.<br />
Examples:<br />
\$BBC_IGNORE_IP = &quot;127., 192.168.&quot;;<br />
\$BBC_IGNORE_IP = &quot;&quot;;",

"config_BBC_IGNORE_REFER" =>
"In case you don't want to have particular referrers from your visitors listed
in your ranking or detailed stats, you can specify one or more keywords used
for blocking if a referrer matches up against them. If you use more keywords,
please use a comma as separator.<br />
Examples:<br />
\$BBC_IGNORE_REFER = &quot;spambot.org, .escort.&quot;;<br />
\$BBC_IGNORE_REFER = &quot;&quot;;",

"config_BBC_IGNORE_BOTS" =>
"You can use this option to determine the treatment of robots. The default is
to ignore them in the top hosts ranking but leave them in the remaining
stats. If you don't want to see any robots at all you can set this option to
&quot;2&quot;, then only human visits will be taken into account.<br />
Examples:<br />
\$BBC_IGNORE_BOTS = 2;<br />
\$BBC_IGNORE_BOTS = 1;<br />
\$BBC_IGNORE_BOTS = &quot;&quot;;",

"config_BBC_IGNORE_AGENT" =>
"This option defines how BBClone tells one visitor from another. Default is to
use the IP address only, which provides realistic figures in most cases. If,
however, your visitors often are hidden behind proxy servers, deactivation of
this option could provide more realistic figures, since a new visitor will be
assumed by the time the user agent has changed.<br />
Examples:<br />
\$BBC_IGNORE_AGENT = 1;<br />
\$BBC_IGNORE_AGENT = &quot;&quot;;",

"config_BBC_KILL_STATS" =>
"Whenever you wish to reset your stats you can activate this switch and have
them deleted by the next visit. Don't forget to deactivate it afterwards, else
you'll probably experience unusually low traffic ;).<br />
Examples:<br />
\$BBC_KILL_STATS = 1;<br />
\$BBC_KILL_STATS = &quot;&quot;;",

"config_BBC_PURGE_SINGLE" =>
"Host and referrer stats can generate a huge amount of data, however mostly
caused by one time visitors. By enabling this switch you can purge these
entries and considerably shrink access.php in its size without affecting your
actual visible host and referrer ranking. The amount of hits will be added to
the &quot;not_specified&quot; entries to keep the overall score intact.<br />
Examples:<br />
\$BBC_PURGE_SINGLE = 1;<br />
\$BBC_PURGE_SINGLE = &quot;&quot;;",

"config_BBC_LOADTIME" =>
"Generate the page load-time in seconds at bottom of the page.<br />
Examples:<br />
\$BBC_LOADTIME =&quot;&quot;;<br />
\$BBC_LOADTIME = 1;",

"config_BBC_EXT_LOOKUP" =>
"This options defines, whether IP addresses are looked up to determine location (country).<br />
These plug-ins are NO part of BBClone, please keep this in mind.<br />
<ul>
<li>IP2EXT => Use the old IP2EXT to Look-Up IP addresses</li>
<li>GEOIP => Use GeoIP API plug-in</li>
<li>GEOIP-mod => Use GeoIP PHP/Perl Module (geoip.so)</li>
</ul>
Examples:<br />
\$BBC_EXT_LOOKUP =&quot;&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;IP2EXT&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP-mod&quot;;",

"config_BBC_CSS_FILE" =>
"BBClone CSS File Name<br />
Please note; Within this css file you can change the way BBClone looks.<br />
(for example change colors or what text size/fonts are used)<br />
Examples:<br />
\$BBC_CSS_FILE =&quot;bbclone.css&quot;;<br />
\$BBC_CSS_FILE =&quot;other.css&quot;;",

"config_BBC_HITS" =>
"Include BBClone hits within the Stats<br />
Examples:<br />
\$BBC_HITS =1;<br />
\$BBC_HITS =&quot;&quot;;",

"config_BBC_USE_ORIGINAL_URI" =>
"Enable this option when the &quot;Top Visited Pages&quot; URI's are not working due
filtering of the URI. This can happen if you use BBClone with some Content
Management Systems (CMS) which are using very long (complex) URI naming.<br />
IMPORTED NOTE: This option changes how URI's are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_USE_ORIGINAL_URI = 1;	=> No filtering, use original URI<br />
\$BBC_USE_ORIGINAL_URI = &quot;&quot;;	=> Filter URI (default)",

"config_BBC_MAX_PAGENAME" =>
"The max. number of characters for the page name.<br />
Longer page names will be stript down at the front, leading with &quot;...&quot;<br />
IMPORTED NOTE: This option changes how page names are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_MAX_PAGENAME = 60;	=> 60 characters (default)"

);
?>
