<?php
/* This file is part of BBClone (A PHP based Web Counter on Steroids)
 * 
 * SVN FILE $Id: pt.php 417 2022-12-21 11:27:14Z joku $
 *  
 * Copyright (C) 2001-2023, the BBClone Team (see doc/authors.txt for details)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * See doc/copying.txt for details
 */

// Language: Portuguese (Português)

// The DNS Extensions array
$extensions = array(
"localdomain" => "Local",
"numeric" => "Numérico",
"unknown" => "Desconhecido",
"museum" => "Museu",
"travel" => "Travel",
"ipv4" => "IPv4",
"ipv6" => "IPv6",

"aero" => "Aero",
"arpa" => "ARPA",
"asia" => "Asia-Pacifico",
"coop" => "Coop",
"info" => "Informação",
"jobs" => "Emprego",
"mobi" => "Mobiles",
"name" => "Pessoal",
"post" => "Serviços Postais",

"biz" => "Negócios",
"cat" => "Catalan",
"com" => "Comercial",
"edu" => "Educacional",
"gal" => "Galician",
"gov" => "Governo",
"int" => "Organizações Internacionais",
"mil" => "Militar dos EUA",
"net" => "Redes",
"org" => "Organizações",
"pro" => "Profissional",
"tel" => "Contactos",
"xxx" => "Pornográfico",

"a1" => "Anonymous Proxy",
"a2" => "Satellite Provider",
"ac" => "Ilha Ascenção",
"ad" => "Andorra",
"ae" => "Emiratos Árabes Unidos",
"af" => "Afeganistão",
"ag" => "Antígua e Barbuda",
"ai" => "Anguilla",
"al" => "Albânia",
"am" => "Arménia",
"an" => "Antilhas Holandesas",
"ao" => "Angola",
"ap" => "Asia-Pacifico",
"aq" => "Antárctida",
"ar" => "Argentina",
"as" => "Samoa Americana",
"at" => "Áustria",
"au" => "Austrália",
"aw" => "Aruba",
"ax" => "Åland",
"az" => "Azerbaijão",
"ba" => "Bósnia e Herzegovina",
"bb" => "Barbados",
"bd" => "Bangladesh",
"be" => "Bélgica",
"bf" => "Burkina Faso",
"bg" => "Bulgária",
"bh" => "Bahrain",
"bi" => "Burundi",
"bj" => "Benin",
"bm" => "Bermudas",
"bn" => "Brunei",
"bo" => "Bolívia",
"br" => "Brasil",
"bs" => "Bahamas",
"bt" => "Butão",
"bw" => "Botsuana",
"by" => "Bielorússia",
"bz" => "Belize",
"ca" => "Canadá",
"cc" => "Ilhas Cocos",
"cd" => "Congo",
"cf" => "República da África Central",
"cg" => "Congo",
"ch" => "Suíca",
"ci" => "Costa do Marfim",
"ck" => "Ilhas Cook",
"cl" => "Chile",
"cm" => "Camarões",
"cn" => "China",
"co" => "Colômbia",
"cr" => "Costa Rica",
"cu" => "Cuba",
"cv" => "Cabo Verde",
"cw" => "Curaçao",
"cx" => "Ilhas Natal",
"cy" => "Chipre",
"cz" => "República Checa",
"de" => "Alemanha",
"dj" => "Djibuti",
"dk" => "Dinamarca",
"dm" => "Dominica",
"do" => "República Dominicana",
"dz" => "Argélia",
"ec" => "Equador",
"ee" => "Estónia",
"eg" => "Egipto",
"er" => "Eritreia",
"es" => "Espanha",
"et" => "Etiópia",
"eu" => "União Europeia",
"fi" => "Finlândia",
"fj" => "Fiji",
"fk" => "Ilhas Falkland",
"fm" => "Micronésia",
"fo" => "Ilhas Faroe",
"fr" => "França",
"ga" => "Gabão",
"gd" => "Granada",
"ge" => "Georgia",
"gf" => "Guiana Francesa",
"gg" => "Guernsey",
"gh" => "Gana",
"gi" => "Gibraltar",
"gl" => "Gronelândia",
"gm" => "Gâmbia",
"gn" => "Guiné",
"gp" => "Guadalupe",
"gq" => "Guiné Equatorial",
"gr" => "Grécia",
"gs" => "Ilhas Sul Georgia e Ilhas Sul Sandwich",
"gt" => "Guatemala",
"gu" => "Guam",
"gw" => "Guiné-Bissau",
"gy" => "Guiana",
"hk" => "Hong Kong",
"hm" => "Ilhas Heard e Mc Donald",
"hn" => "Honduras",
"hr" => "Croácia",
"ht" => "Haiti",
"hu" => "Hungria",
"id" => "Indonésia",
"ie" => "Irlanda",
"il" => "Israel",
"im" => "Ilha de Man",
"in" => "Índia",
"io" => "Território Britânico no Oceano Índico",
"iq" => "Iraque",
"ir" => "Irão",
"is" => "Islândia",
"it" => "Itália",
"je" => "Jersey",
"jm" => "Jamaica",
"jo" => "Jordânia",
"jp" => "Japão",
"ke" => "Quénia",
"kg" => "Quirguiquistão",
"kh" => "Cambodja",
"ki" => "Kiribati",
"km" => "Comoros",
"kn" => "Saint Kitts e Nevis",
"kp" => "Coreia do Norte",
"kr" => "Coreia do Sul",
"kw" => "Kuwait",
"ky" => "Ilhas Caimam",
"kz" => "Casaquistão",
"la" => "Laos",
"lb" => "Líbano",
"lc" => "Santa Lúcia",
"li" => "Liechtenstein",
"lk" => "Sri Lanka",
"lr" => "Libéria",
"ls" => "Lesoto",
"lt" => "Lituânia",
"lu" => "Luxemburgo",
"lv" => "Letónia",
"ly" => "Líbia",
"ma" => "Marrocos",
"mc" => "Mónaco",
"md" => "Moldávia",
"me" => "Montenegro",
"mg" => "Madagáscar",
"mh" => "Ilhas Marshall",
"mk" => "Macedónia",
"ml" => "Mali",
"mm" => "Myanmar",
"mn" => "Mongólia",
"mo" => "Macau",
"mp" => "Ilhas Mariana do Norte",
"mq" => "Martinica",
"mr" => "Mauritania",
"ms" => "Montserrat",
"mt" => "Malta",
"mu" => "Mauritania",
"mv" => "Maldivas",
"mw" => "Malauí",
"mx" => "México",
"my" => "Malásia",
"mz" => "Moçambique",
"na" => "Namíbia",
"nc" => "Nova Caledónia",
"ne" => "Níger",
"nf" => "Ilha Norfolk",
"ng" => "Nigéria",
"ni" => "Nicarágua",
"nl" => "Holanda",
"no" => "Noruega",
"np" => "Nepal",
"nr" => "Nauru",
"nu" => "Niue",
"nz" => "Nova Zelândia",
"om" => "Omã",
"pa" => "Panamá",
"pe" => "Perú",
"pf" => "Polinésia Francesa",
"pg" => "Papua Nova Guiné",
"ph" => "Filipinas",
"pk" => "Paquistão",
"pl" => "Polónia",
"pm" => "St. Pierre e Miquelon",
"pn" => "Pitcairn",
"pr" => "Porto Rico",
"ps" => "Palestina",
"pt" => "Portugal",
"pw" => "Palau",
"py" => "Paraguai",
"qa" => "Qatar",
"re" => "Reunião",
"ro" => "Roménia",
"rs" => "Sérvia",
"ru" => "Rússia",
"rw" => "Ruanda",
"sa" => "Arábia Saudita",
"sb" => "Ilhas Salomão",
"sc" => "Seycheles",
"sd" => "Sudão",
"se" => "Suécia",
"sg" => "Singapura",
"sh" => "St. Helena",
"si" => "Eslovênia",
"sk" => "Eslováquia",
"sl" => "Serra Leoa",
"sm" => "San Marino",
"sn" => "Senegal",
"so" => "Somália",
"sr" => "Suriname",
"st" => "São Tomé e Príncipe",
"su" => "União Soviética",
"sv" => "El Salvador",
"sx" => "Sint Maarten",
"sy" => "Síria",
"sz" => "Suazilandia",
"tc" => "Ilhas Turks e Caicos",
"td" => "Chade",
"tf" => "Território do Sul da França",
"tg" => "Togo",
"th" => "Tailândia",
"tj" => "Tajiquistão",
"tk" => "Tokelau",
"tl" => "Timor Leste",
"tm" => "Turcomenistão",
"tn" => "Tunísia",
"to" => "Tonga",
"tp" => "Timor Leste",
"tr" => "Turquia",
"tt" => "Trinidad e Tobago",
"tv" => "Tuvalu",
"tw" => "Taiwan",
"tz" => "Tanzânia",
"ua" => "Ucrânia",
"ug" => "Uganda",
"uk" => "Reino Unido",
"us" => "Estados Unidos",
"uy" => "Uruguai",
"uz" => "Uzbequistão",
"va" => "Estado do Vaticano",
"vc" => "St. Vincent e Grenadines",
"ve" => "Venezuela",
"vg" => "Ilhas Virgens (UK)",
"vi" => "Ilhas Virgens (EUA)",
"vn" => "Vietname",
"vu" => "Vanuatu",
"wf" => "Ilhas Wallis e Futuna",
"ws" => "Samoa",
"ye" => "Iémene",
"yt" => "Mayotte",
"za" => "África do Sul",
"zm" => "Zâmbia",
"zw" => "Zimbábue",

// No longer active but needed for history purpose
"bl" => "São Bartolomeu (Antilhas Francesas)",
"bv" => "Ilha Bouvet", 
"bq" => "Caribe Holanda",
"cs" => "Sérvia e Montenegro",
"eh" => "Sahara Ocidental",
"gb" => "Grã-Bretanha",
"mf" => "Saint-Martin",
"sj" => "Ilhas Svalbard e Jan Mayen",
"ss" => "Sudão do Sul",
"um" => "Ilhas menores dos EUA",
"yu" => "Sérvia e Montenegro",
"zr" => "Zaire"
);

// The main Translation array
$translation = array(

// Specific charset
"global_charset" => "utf-8",

// Global translation
"global_titlebar"=> "Estatísticas de %SERVER, geradas em %DATE",
"global_bbclone_copyright" => "A equipa BBClone - Distribuído sob a Licença",
"global_last_reset" => "As estatísticas foram reiniciadas em",
"global_yes" => "Sim",
"global_no" => "Não",

// The error messages
"error_cannot_see_config" =>
"Não é permitido ver a configuração do BBClone neste servidor.",

// Date format (used with date())
"global_time_format" => "M jS, H:i:s",
"global_day_format" => "l F jS, Y",
"global_hours_format" => "l F jS, G:00",
"global_month_format" => "F Y",

// Miscellaneous translations
"misc_other" => "Outro",
"misc_unknown" => "Desconhecido",
"misc_second_unit" => "seg.",
"misc_ignored" => "Ignorado",

// The Navigation Bar
"navbar_main_site" => "Sítio Principal",
"navbar_configuration" => "Configuração",
"navbar_global_stats" => "Estatísticas Globais",
"navbar_detailed_stats" => "Estatísticas Detalhadas",
"navbar_time_stats" => "Estatísticas Cronológicas",
"navbar_language" => "Lingua",
"navbar_go" => "ir",

// Detailed Stats words
"dstat_id" => "ID",
"dstat_time" => "Data/Hora",
"dstat_visits" => "Visitas",
"dstat_extension" => "Extensão",
"dstat_dns" => "Serviços de Acesso",
"dstat_from" => "Proveniência",
"dstat_os" => "Sistema Operativo",
"dstat_browser" => "Navegador",
"dstat_visible_rows" => "Acessos Visíveis",
"dstat_green_rows" => "Linhas Verdes",
"dstat_blue_rows" => "Linhas Azuis",
"dstat_red_rows" => "Linhas Vermelhas",
"dstat_search" => "Busca",
"dstat_last_page" => "Última Página",
"dstat_last_visit" => "Última Visita",
"dstat_robots" => "Robôs",
"dstat_my_visit" => "Visitas a partir do seu IP",
"dstat_no_data" => "Sem dados disponíveis",
"dstat_prx" => "Servidor de Proximidade",
"dstat_ip" => "Endereço IP",
"dstat_user_agent" => "Pormenores do Navegador Utilizado",
"dstat_nr" => "Nº",
"dstat_pages" => "Páginas",
"dstat_visit_length" => "Duração da Visita",
"dstat_reloads" => "Recargas",
"dstat_whois_information" => "Procure informações sobre este endereço IP",

// Global Stats words
"gstat_accesses" => "Acessos",
"gstat_total_visits" => "Total Visitas",
"gstat_total_unique" => "Total Únicas",
"gstat_operating_systems" => "Sistemas Operativos: %d Mais",
"gstat_browsers" => "Navegadores: %d Mais",
"gstat_extensions" => "Extensões: %d Mais",
"gstat_robots" => "Robôs: %d Mais",
"gstat_pages" => "Páginas Visitadas: %d Mais",
"gstat_origins" => "Origens: %d Mais",
"gstat_hosts" => "Serviços de Acesso: %d Mais",
"gstat_keys" => "Palavras-chave: %d Mais",
"gstat_total" => "Total",
"gstat_not_specified" => "Não especificado",

// Time Stats words
"tstat_su" => "Dom",
"tstat_mo" => "Seg",
"tstat_tu" => "Ter",
"tstat_we" => "Qua",
"tstat_th" => "Qui",
"tstat_fr" => "Sex",
"tstat_sa" => "Sáb",

"tstat_full_su" => "Domingo",
"tstat_full_mo" => "Monday",
"tstat_full_tu" => "terça-feira",
"tstat_full_we" => "Quarta",
"tstat_full_th" => "quinta-feira",
"tstat_full_fr" => "Friday",
"tstat_full_sa" => "Sábado",

"tstat_jan" => "Jan",
"tstat_feb" => "Fev",
"tstat_mar" => "Mar",
"tstat_apr" => "Abr",
"tstat_may" => "Mai",
"tstat_jun" => "Jun",
"tstat_jul" => "Jul",
"tstat_aug" => "Ago",
"tstat_sep" => "Set",
"tstat_oct" => "Out",
"tstat_nov" => "Nov",
"tstat_dec" => "Dez",

"tstat_full_jan" => "Janeiro",
"tstat_full_feb" => "Fevereiro",
"tstat_full_mar" => "Março",
"tstat_full_apr" => "Abril",
"tstat_full_may" => "Maio",
"tstat_full_jun" => "Junho",
"tstat_full_jul" => "Julho",
"tstat_full_aug" => "Agosto",
"tstat_full_sep" => "Setembro",
"tstat_full_oct" => "Outubro",
"tstat_full_nov" => "Novembro",
"tstat_full_dec" => "December",

"tstat_last_day" => "Último Dia",
"tstat_last_week" => "Última Semana",
"tstat_last_month" => "Último Mês",
"tstat_last_year" => "Último Ano",
"tstat_average" => "média",

// Loadtime notice
"generated" => "Página gerada em ",
"seconds" => " segundos",

// Configuration page words and sentences
"config_variable_name" => "Nome da Variável",
"config_variable_value" => "Valor da Variável",
"config_explanations" => "Explicações",

"config_BBC_MAINSITE" =>
"Se esta variável foi atribuída, uma ligação ao sítio especificado será gerada. Por defeito, o valor aponta para o directório principal. No caso de o seu sítio estar alojado noutro local, terá que ajustar o valor em conformidade.<br />
Exemplos:<br />
\$BBC_MAINSITE = &quot;http://www.myserver.com/&quot;;<br />
\$BBC_MAINSITE = &quot;..&quot;;<br />
\$BBC_MAINSITE = &quot;&quot;;",

"config_BBC_SHOW_CONFIG" =>
"Por defeito o BBClone mostra o acesso às preferências das estatísticas. No caso de desejar negar o acesso às preferências, desactive esta opção.<br />
Exemplos:<br />
\$BBC_SHOW_CONFIG = 1;<br />
\$BBC_SHOW_CONFIG = &quot;&quot;;",

"config_BBC_TITLEBAR" =>
"O título aparecendo dentro da barra de título presente em todas páginas do BBClone.<br />
Variáveis reconhecíveis são:<br />
<ul>
<li>%SERVER: Nome do Servidor,</li>
<li>%DATE: A Data corrente.</li>
</ul>
Etiquetas HTML são também permitidas.<br />
Exemplos:<br />
\$BBC_TITLEBAR = &quot;Estatísticas de %SERVER, geradas em %DATE&quot;;<br />
\$BBC_TITLEBAR = &quot;As minhas estatísticas de %DATE são estas:&quot;;
<br />",

"config_BBC_LANGUAGE" =>
"O idioma a utilizar por defeito pelo BBClone, isto no caso de não ter sido especificado pelo browser.
Os seguintes idiomas estão disponíveis:
<p>ar, bg, bs, ca, cs, da, de, el, en, es, fi, fr, hu, id, it, ja, ko, lt, mk, nb,
nl, pl, pt, pt-br, ro, ru, sk, sl, sv, th, tr, ua, zh-cn and zh-tw</p>",

"config_BBC_MAXTIME" =>
"Esta variável define a duração em segundos, de uma visita única. Cada solicitação (hit) do visitante num deteminado período de tempo será considerada como uma visita única, desde que duas solicitações (hits) sucessivas não excedam o limite de tempo especificado. O valor por defeito é de 30 minutos (1800 segundos) que é o standard na internet, mas dependendo das suas necessidades, poderá atribuir um valor diferente.<br />
Exemplos:<br />
\$BBC_MAXTIME = 0;<br />
\$BBC_MAXTIME = 1800;",

"config_BBC_MAXVISIBLE" =>
"Quantas entradas quer ver listadas nas estatísticas detalhadas? Por defeito o valor é 100. É recomendável um valor não superior a 500 por forma a evitar tempos de carregamento muito grandes.",

"config_BBC_DETAILED_STAT_FIELDS" =>
"A variável \$BBC_DETAILED_STAT_FIELDS determina quais as colunas a serem mostradas nas estatísticas detalhadas. Valores possíveis são:
<ul>
<li>id => O número de ordem do visitante</li>
<li>time => A Data/Hora em que a última solicitação (hit) foi registada</li>
<li>visits => As solicitações (hits) de um único visitante</li>
<li>dns => O nome do serviço de acesso do visitante</li>
<li>ip => O endereço IP do visitante</li>
<li>os => O Sistema Operativo (se disponível e/ou sem robô)</li>
<li>browser => O navegador utilizado para estabelecer a ligação</li>
<li>ext => O País ou extensão do visitante</li>
<li>referer => A proveniência do visitante (se disponível)</li>
<li>page => A última página visitada</li>
<li>search => A Palavra-chave utilizada pelo visitante (se disponível)</li>
</ul>
A ordem com que ordenar as colunas será usada na visualização das mesmas.<br />
Exemplos:<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;id, time, visits, ip, ext, os, browser&quot;;
<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;date, ext, browser, os, ip&quot;;<br />",

"config_BBC_TIME_OFFSET" =>
"No caso de a hora do servidor não ser igual à sua hora, poderá ajustá-la com esta opção (em minutos). Valores negativos atrasarão e os positivos adiantarão a hora.<br />
Exemplos:<br />
\$BBC_TIME_OFFSET = 300;<br />
\$BBC_TIME_OFFSET = -300;<br />
\$BBC_TIME_OFFSET = 0;",

"config_BBC_NO_DNS" =>
"Esta opção define se os endereços de IP (numéricos) devem ser ou não traduzidos pelos nomes dos serviços de acesso. Muito embora os nomes dos serviços de acesso digam bastante sobre o visitante, a sua obtenção pode diminuir consideravelmente a velocidade do seu sítio, no caso dos servidores de DNS serem lentos, limitados na sua capacidade ou irregulares no seu serviço. Ajustando esta variável poderá solucionar o problema.<br />
Exemplos:<br />
\$BBC_NO_DNS = 1;<br />
\$BBC_NO_DNS = &quot;&quot;;",

"config_BBC_NO_HITS" =>
"Por defeito o BBClone mostra as solicitações (hits) nas estatísticas cronológicas, porque assim se obtem uma muito útil ideia da utilização do servidor. No entanto, se preferir ter as visitas únicas como base para as suas estatísticas cronológicas, poderá mudar o tipo de contagem através desta variável.<br />
Exemplos:<br />
\$BBC_NO_HITS = 1;<br />
\$BBC_NO_HITS = &quot;&quot;;",

"config_BBC_IGNORE_IP" =>
"Esta opção pode ser usada para excluir da contagem um endereço de IP em particular ou grupos de endereços de IP. No caso de pretender adicionar diversas expressões, use uma vírgula como separador.<br />
Exemplos:<br />
\$BBC_IGNORE_IP = &quot;127., 192.168.&quot;;<br />
\$BBC_IGNORE_IP = &quot;&quot;;",

"config_BBC_IGNORE_REFER" =>
"No caso de não querer considerar uma proveniência (referer) em particular, pode especificar uma ou mais palavras-chave por forma a bloquear a sua contagem. Se usar mais do uma palavra-chave, use vírgulas como separador.<br />
Exemplos:<br />
\$BBC_IGNORE_REFER = &quot;spambot.org, .escort.&quot;;<br />
\$BBC_IGNORE_REFER = &quot;&quot;;",

"config_BBC_IGNORE_BOTS" =>
"Use esta opção para definir a forma como são tratados os dados referntes aos robôs. Por defeito, eles são ignorados nos serviços de acesso, mas são considerados nas restantes estatísticas. Se de todo, não quiser ver dados referentes aos robôs, atribua a esta opção o valor &quot;2&quot;, e apenas as visitas humanas serão tidas em conta.<br />
Exemplos:<br />
\$BBC_IGNORE_BOTS = 2;<br />
\$BBC_IGNORE_BOTS = 1;<br />
\$BBC_IGNORE_BOTS = &quot;&quot;;",

"config_BBC_IGNORE_AGENT" =>
"Esta opção define a forma como o BBClone diferencia um visitante de outro. Por defeito, usa apenas o endereço de IP que, fornece dados realistas na maior parte dos casos. Porém, se os seus visitantes usarem servidores de proximidade, a desactivação desta opção fornecerá dados mais fidedignos, já que será assumido um novo visitante quando se der uma mudança nos pormenores do navegador utilizado.<br />
Exemplos:<br />
\$BBC_IGNORE_AGENT = 1;<br />
\$BBC_IGNORE_AGENT = &quot;&quot;;",

"config_BBC_KILL_STATS" =>
"Sempre que deseje reinicializar as suas estatísticas, poderá activar esta opção e na próxima visita elas serão apagadas. Não se esqueça porém de desactivar esta opção a seguir, caso contrário experimentará um anormal baixo trâfego ;).<br />
Exemplos:<br />
\$BBC_KILL_STATS = 1;<br />
\$BBC_KILL_STATS = &quot;&quot;;",

"config_BBC_PURGE_SINGLE" =>
"Os serviços de acesso (host) e as proveniências (referer) podem gerar um enorme volume de dados, embora causados por visitantes únicos. Se activar esta opção poderá filtrar essas entradas e diminuir consideravelmente o ficheiro access.php no seu tamanho, sem afectar a tabela de serviços de acesso e proveniências. As solicitações (hits) serão adicionadas às entradas &quot;not_specified&quot; por forma a manter intacto o valor total.<br />
Exemplos:<br />
\$BBC_PURGE_SINGLE = 1;<br />
\$BBC_PURGE_SINGLE = &quot;&quot;;",

"config_BBC_LOADTIME" =>
"Generate the page load-time in seconds at bottom of the page.<br />
Examples:<br />
\$BBC_LOADTIME =&quot;&quot;;<br />
\$BBC_LOADTIME = 1;",

"config_BBC_EXT_LOOKUP" =>
"This options defines, whether IP addresses are looked up to determine location (country).<br />
These plug-ins are NO part of BBClone, please keep this in mind.<br />
<ul>
<li>IP2EXT => Use the old IP2EXT to Look-Up IP addresses</li>
<li>GEOIP => Use GeoIP API plug-in</li>
<li>GEOIP-mod => Use GeoIP PHP/Perl Module (geoip.so)</li>
</ul>
Examples:<br />
\$BBC_EXT_LOOKUP =&quot;&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;IP2EXT&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP-mod&quot;;",

"config_BBC_CSS_FILE" =>
"BBClone CSS File Name<br />
Please note; Within this css file you can change the way BBClone looks.<br />
(for example change colors or what text size/fonts are used)<br />
Examples:<br />
\$BBC_CSS_FILE =&quot;bbclone.css&quot;;<br />
\$BBC_CSS_FILE =&quot;other.css&quot;;",

"config_BBC_HITS" =>
"Include BBClone hits within the Stats<br />
Examples:<br />
\$BBC_HITS =1;<br />
\$BBC_HITS =&quot;&quot;;",

"config_BBC_USE_ORIGINAL_URI" =>
"Enable this option when the &quot;Top Visited Pages&quot; URI's are not working due
filtering of the URI. This can happen if you use BBClone with some Content
Management Systems (CMS) which are using very long (complex) URI naming.<br />
IMPORTED NOTE: This option changes how URI's are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_USE_ORIGINAL_URI = 1;	=> No filtering, use original URI<br />
\$BBC_USE_ORIGINAL_URI = &quot;&quot;;	=> Filter URI (default)",

"config_BBC_MAX_PAGENAME" =>
"The max. number of characters for the page name.<br />
Longer page names will be stript down at the front, leading with &quot;...&quot;<br />
IMPORTED NOTE: This option changes how page names are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_MAX_PAGENAME = 60;	=> 60 characters (default)"

);
?>
