<?php
/* This file is part of BBClone (A PHP based Web Counter on Steroids)
 * 
 * SVN FILE $Id: zh-tw.php 417 2022-12-21 11:27:14Z joku $
 *  
 * Copyright (C) 2001-2023, the BBClone Team (see doc/authors.txt for details)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * See doc/copying.txt for details
 */

// Language: Traditional Chinese (中文(繁體))

// The DNS Extensions array
$extensions = array(
"localdomain" => "當地",
"numeric" => "（數字）",
"unknown" => "（不明）",
"museum" => "（博物館）",
"travel" => "旅遊",
"ipv4" => "IPv4的",
"ipv6" => "IPv6的",

"aero" => "用於航空工业",
"arpa" => "（美國老式網路）",
"asia" => "用于亚洲地区",
"coop" => "（共合）",
"info" => "（資訊）",
"jobs" => "职业介绍",
"mobi" => "用于移动通信领域",
"name" => "（個人）",
"post" => "郵政服務",

"biz" => "（商務）",
"cat" => "加泰罗尼亚语区都可注册",
"com" => "（美國商務）",
"edu" => "（美國教育）",
"gal" => "加利西亞",
"gov" => "（美國政府）",
"int" => "（國際組織）",
"mil" => "（美國軍隊）",
"net" => "（網路）",
"org" => "（非營利組織）",
"pro" => "（專業）",
"tel" => "用于电信行业",
"xxx" => "成人内容",

"a1" => "匿名代理",
"a2" => "衛星供應商",
"ac" => "阿森松島",
"ad" => "安道爾共和國",
"ae" => "阿拉伯聯合大公國",
"af" => "阿富汗",
"ag" => "安地卡及巴布達",
"ai" => "安圭拉",
"al" => "阿爾巴尼亞",
"am" => "亞美尼亞",
"an" => "荷屬安地列斯群島",
"ao" => "安哥拉",
"ap" => "用于亚洲地区",
"aq" => "南極洲",
"ar" => "阿根廷",
"as" => "美屬薩摩亞",
"at" => "奧地利",
"au" => "澳大利亞",
"aw" => "阿魯巴",
"ax" => "奧蘭群島",
"az" => "阿塞拜疆",
"ba" => "波斯尼亞-黑塞哥維那",
"bb" => "巴巴多斯",
"bd" => "孟加拉",
"be" => "比利時",
"bf" => "布基納法索",
"bg" => "保加利亞",
"bh" => "巴林",
"bi" => "布隆迪",
"bj" => "貝寧",
"bm" => "百慕達",
"bn" => "文萊",
"bo" => "玻利維亞",
"br" => "巴西",
"bs" => "巴哈馬",
"bt" => "不丹",
"bw" => "波札那",
"by" => "白俄羅斯",
"bz" => "貝里斯",
"ca" => "加拿大",
"cc" => "可可島",
"cd" => "剛果",
"cf" => "中非共和國",
"cg" => "剛果",
"ch" => "瑞士",
"ci" => "象牙海岸",
"ck" => "科克群島",
"cl" => "智利",
"cm" => "喀麥隆",
"cn" => "中國",
"co" => "哥倫比亞",
"cr" => "哥斯大黎加",
"cu" => "古巴",
"cv" => "維德角共和國",
"cw" => "庫拉索島",
"cx" => "聖誕島",
"cy" => "塞浦路斯",
"cz" => "捷克",
"de" => "德國",
"dj" => "吉布地共和國",
"dk" => "丹麥",
"dm" => "多米尼克",
"do" => "多米尼加共和國",
"dz" => "阿爾及利亞",
"ec" => "厄瓜多爾",
"ee" => "愛沙尼亞",
"eg" => "埃及",
"er" => "厄立特里亞",
"es" => "西班牙",
"et" => "衣索比亞",
"eu" => "歐聯",
"fi" => "芬蘭",
"fj" => "斐濟群島",
"fk" => "福克蘭群島",
"fm" => "密克羅尼西亞",
"fo" => "法魯群島",
"fr" => "法國",
"ga" => "加彭",
"gd" => "格瑞那達",
"ge" => "格魯吉亞",
"gf" => "法屬圭亞那",
"gg" => "根西島",
"gh" => "迦魶",
"gi" => "直布羅陀",
"gl" => "格陵蘭島",
"gm" => "甘比亞",
"gn" => "幾內亞",
"gp" => "加勒比群島",
"gq" => "赤道幾內亞",
"gr" => "希臘",
"gs" => "南喬治亞",
"gt" => "瓜地馬拉",
"gu" => "關島",
"gw" => "幾內亞比索",
"gy" => "蓋亞那",
"hk" => "香港",
"hm" => "赫德及麥當勞群島",
"hn" => "洪都拉斯",
"hr" => "克羅地亞",
"ht" => "海地",
"hu" => "匈牙利",
"id" => "印度尼西亞",
"ie" => "愛爾蘭",
"il" => "以色列",
"im" => "曼島",
"in" => "印度",
"io" => "英屬印度洋領地",
"iq" => "伊拉克",
"ir" => "伊朗",
"is" => "冰島",
"it" => "意大利",
"je" => "澤西",
"jm" => "牙買加",
"jo" => "約旦",
"jp" => "日本",
"ke" => "肯亞",
"kg" => "吉魯濟斯坦",
"kh" => "柬埔寨",
"ki" => "吉里巴斯",
"km" => "科摩羅群島",
"kn" => "聖及斯",
"kp" => "北韓",
"kr" => "南韓",
"kw" => "科威特",
"ky" => "開曼群島",
"kz" => "哈薩克",
"la" => "遼國",
"lb" => "黎巴嫩",
"lc" => "聖路西亞",
"li" => "列支敦士坦",
"lk" => "斯里蘭卡",
"lr" => "賴比瑞亞",
"ls" => "賴索托",
"lt" => "立陶宛",
"lu" => "盧森堡",
"lv" => "拉脫維亞",
"ly" => "利比亞",
"ma" => "摩洛哥",
"mc" => "摩納哥",
"md" => "摩爾達維亞",
"me" => "黑山",
"mg" => "馬達加斯加",
"mh" => "馬紹爾群島",
"mk" => "馬其頓",
"ml" => "馬里",
"mm" => "緬甸",
"mn" => "蒙古",
"mo" => "澳門",
"mp" => "北馬里亞納群島",
"mq" => "馬提尼克島",
"mr" => "茅利塔尼亞",
"ms" => "蒙特塞拉特島",
"mt" => "馬爾他",
"mu" => "模里西斯",
"mv" => "馬爾地夫",
"mw" => "馬拉威",
"mx" => "墨西哥",
"my" => "馬來西亞",
"mz" => "莫三比克",
"na" => "納米比亞",
"nc" => "新卡里多尼亞",
"ne" => "尼日",
"nf" => "諾福克島",
"ng" => "奈及利亞",
"ni" => "尼加拉瓜",
"nl" => "荷蘭",
"no" => "挪威",
"np" => "尼泊爾",
"nr" => "諾魯",
"nu" => "紐鄂島",
"nz" => "紐西蘭",
"om" => "阿曼",
"pa" => "巴拿馬",
"pe" => "秘魯",
"pf" => "法屬波利尼西亞",
"pg" => "巴布亞新幾內亞",
"ph" => "菲律賓",
"pk" => "巴基斯坦",
"pl" => "波蘭",
"pm" => "聖皮埃爾島及密客隆島",
"pn" => "英屬皮特克恩群島",
"pr" => "波多黎各",
"ps" => "巴勒斯坦",
"pt" => "葡萄牙",
"pw" => "帕勞",
"py" => "巴拉圭",
"qa" => "卡塔爾",
"re" => "留尼旺島",
"ro" => "羅馬尼亞",
"rs" => "Serbia",
"ru" => "俄羅斯",
"rw" => "盧旺達",
"sa" => "沙烏地阿拉伯",
"sb" => "所羅門群島",
"sc" => "塞席爾",
"sd" => "蘇丹",
"se" => "瑞典",
"sg" => "新加坡",
"sh" => "聖赫勒拿島",
"si" => "斯洛維尼亞",
"sk" => "斯洛伐克",
"sl" => "獅子山",
"sm" => "聖馬利諾",
"sn" => "塞內加爾",
"so" => "索馬利亞",
"sr" => "蘇里南",
"st" => "聖多美",
"su" => "蘇聯",
"sv" => "薩爾瓦多",
"sx" => "聖馬丁",
"sy" => "敘利亞",
"sz" => "史瓦濟蘭",
"tc" => "特克斯和凱科斯群島",
"td" => "查德",
"tf" => "法屬南部屬地",
"tg" => "多哥",
"th" => "泰國",
"tj" => "塔吉克",
"tk" => "塔開盧群島",
"tl" => "東帝汶",
"tm" => "土庫曼",
"tn" => "突尼西亞",
"to" => "東加",
"tp" => "東帝汶",
"tr" => "土耳其",
"tt" => "千里達托貝哥",
"tv" => "吐瓦魯",
"tw" => "台灣",
"tz" => "坦桑尼亞",
"ua" => "烏克蘭",
"ug" => "烏干達",
"uk" => "英國",
"us" => "美國",
"uy" => "烏拉圭",
"uz" => "烏玆別克斯坦",
"va" => "梵蒂岡城",
"vc" => "聖文森及格瑞那丁特島",
"ve" => "委內瑞拉",
"vg" => "英屬維爾京群島",
"vi" => "美屬維爾京群島",
"vn" => "越南",
"vu" => "萬那杜",
"wf" => "瓦里斯及富都拿群島",
"ws" => "西薩摩亞",
"ye" => "葉門",
"yt" => "馬約特島",
"za" => "南非",
"zm" => "尚比亞",
"zw" => "辛巴威",

// No longer active but needed for history purpose
"bl" => "聖巴泰勒米",
"bv" => "波維特島",
"bq" => "加勒比海荷蘭",
"cs" => "塞爾維亞和黑山",
"eh" => "西撒哈拉",
"gb" => "英國",
"mf" => "庫拉索島",
"sj" => "斯瓦巴及尖棉",
"ss" => "南蘇丹",
"um" => "美國外島",
"yu" => "塞爾維亞",
"zr" => "薩伊"
);

// The main Translation array
$translation = array(

// Specific charset
"global_charset" => "utf-8",

// Date format (used with date())
"global_time_format" => "M jS, H:i:s",
"global_day_format" => "l F jS, Y",
"global_hours_format" => "l F jS, G:00",
"global_month_format" => "F Y",

// Global translation
"global_titlebar"=> "統計 %SERVER 產生的 %DATE",
"global_bbclone_copyright" => "該 BBClone 小組 版權所有",
"global_last_reset" => "統計數字起始自",
"global_yes" => "是",
"global_no" => "否",

// The error messages
"error_cannot_see_config" =>
"設定不允許您察看 BBClone 的設定檔.",

// Miscellaneous translations
"misc_other" => "其它",
"misc_unknown" => "不明",
"misc_second_unit" => "秒",
"misc_ignored" => "略過",

// The Navigation Bar
"navbar_main_site" => "我的主頁",
"navbar_configuration" => "設定變數",
"navbar_global_stats" => "訪客總覽",
"navbar_detailed_stats" => "訪客細節",
"navbar_time_stats" => "時段統計",
"navbar_language" => "語",
"navbar_go" => "去",

// Detailed Stats words
"dstat_id" => "標號",
"dstat_time" => "時間",
"dstat_visits" => "頁數",
"dstat_extension" => "國籍",
"dstat_dns" => "網域名稱",
"dstat_from" => "來源",
"dstat_os" => "作業系統",
"dstat_browser" => "瀏覽器",
"dstat_visible_rows" => "顯示行數",
"dstat_green_rows" => "綠色行",
"dstat_blue_rows" => "藍色行",
"dstat_red_rows" => "紅色行",
"dstat_search" => "搜尋字串",
"dstat_last_page" => "最後查看",
"dstat_last_visit" => "查看最後一頁的時間",
"dstat_robots" => "搜索機器人",
"dstat_my_visit" => "從你的IP訪問",
"dstat_no_data" => "無紀錄資料",
"dstat_prx" => "代理伺服器",
"dstat_ip" => "IP 位置",
"dstat_user_agent" => "系統",
"dstat_nr" => "數",
"dstat_pages" => "頁面",
"dstat_visit_length" => "瀏覽時間",
"dstat_reloads" => "重整次數",
"dstat_whois_information" => "查查資料共享這一個IP地址",

// Global Stats words
"gstat_accesses" => "總流量",
"gstat_total_visits" => "訪客人次",
"gstat_total_unique" => "訪客人數",
"gstat_operating_systems" => "前%d作業系統",
"gstat_browsers" => "前%d瀏覽器",
"gstat_extensions" => "前%d國籍",
"gstat_robots" => "前%d搜索機器人",
"gstat_pages" => "前%d拜訪網頁",
"gstat_origins" => "前%d來源",
"gstat_hosts" => "前%d網域",
"gstat_keys" => "前%d搜尋字串",
"gstat_total" => "總計",
"gstat_not_specified" => "不明",

// Time Stats words
"tstat_su" => "星期日",
"tstat_mo" => "星期一",
"tstat_tu" => "星期二",
"tstat_we" => "星期三",
"tstat_th" => "星期四",
"tstat_fr" => "星期五",
"tstat_sa" => "星期六",

"tstat_full_su" => "星期日",
"tstat_full_mo" => "星期一",
"tstat_full_tu" => "星期二",
"tstat_full_we" => "星期三",
"tstat_full_th" => "星期四",
"tstat_full_fr" => "星期五",
"tstat_full_sa" => "星期六",

"tstat_jan" => "一月",
"tstat_feb" => "二月",
"tstat_mar" => "三月",
"tstat_apr" => "四月",
"tstat_may" => "五月",
"tstat_jun" => "六月",
"tstat_jul" => "七月",
"tstat_aug" => "八月",
"tstat_sep" => "九月",
"tstat_oct" => "十月",
"tstat_nov" => "十一",
"tstat_dec" => "十二",

"tstat_jan" => "一月",
"tstat_feb" => "二月",
"tstat_mar" => "三月",
"tstat_apr" => "四月",
"tstat_may" => "五月",
"tstat_jun" => "六月",
"tstat_jul" => "七月",
"tstat_aug" => "八月",
"tstat_sep" => "九月",
"tstat_oct" => "十月",
"tstat_nov" => "十一",
"tstat_dec" => "十二",

"tstat_last_day" => "過去一天",
"tstat_last_week" => "過去一週",
"tstat_last_month" => "過去一月",
"tstat_last_year" => "過去一年",
"tstat_average" => "平均",

// Loadtime notice
"generated" => "在生成的页面 ",
"seconds" => " 秒",

// Configuration page words and sentences
"config_variable_name" => "變數名稱",
"config_variable_value" => "變數數值",
"config_explanations" => "解釋",

"config_BBC_MAINSITE" =>
"If this variable has been set, a link to the specified location will be
generated. The default value is pointing to the parent directory. In case your
main site is located elsewhere, you probably want to adjust the value to suit
your needs.<br />
Examples:<br />
\$BBC_MAINSITE = &quot;http://www.myserver.com/&quot;;<br />
\$BBC_MAINSITE = &quot;..&quot;;<br />
\$BBC_MAINSITE = &quot;&quot;;",

"config_BBC_SHOW_CONFIG" =>
"BBClone defaults to revealing the stats' settings. In case this behavior isn't
desired you can deny access to it by deactivating the option.<br />
Examples:<br />
\$BBC_SHOW_CONFIG = 1;<br />
\$BBC_SHOW_CONFIG = &quot;&quot;;",

"config_BBC_TITLEBAR" =>
"The title of your stats pages.<br />
It will be displayed in the navigation bar of all BBClone pages<br />
The following macros are recognised:<br />
<ul>
<li>%SERVER: server name,</li>
<li>%DATE: current date.</li>
</ul>
HTML Tags are allowed.<br />
Examples:<br />
\$BBC_TITLEBAR = &quot;Statistics for %SERVER generated the %DATE&quot;;<br />
\$BBC_TITLEBAR = &quot;My stats from %DATE look like this:&quot;;
<br />",

"config_BBC_LANGUAGE" =>
"BBClone's default language, in case it hasn't been specified by the browser.
The following languages are supported:
<p>ar, bg, bs, ca, cs, da, de, el, en, es, fi, fr, hu, id, it, ja, ko, lt, mk, nb,
nl, pl, pt, pt-br, ro, ru, sk, sl, sv, th, tr, ua, zh-cn and zh-tw</p>",

"config_BBC_MAXTIME" =>
"This variable defines the length of an unique visit in seconds. Each hit from
the same visitor within this period will be considered as one visit, as long as
two successive hits don't exceed the specified limit. Default is the de facto
web standard of 30 minutes (1800 seconds), but depending on your needs you may
wish to assign a different value.<br />
Examples:<br />
\$BBC_MAXTIME = 0;<br />
\$BBC_MAXTIME = 1800;",

"config_BBC_MAXVISIBLE" =>
"How many entries you want to have listed in the detailed stats? The default
value is 100. It's recommended not to set it higher than 500 to avoid too heavy
load.",

"config_BBC_DETAILED_STAT_FIELDS" =>
"The variable \$BBC_DETAILED_STAT_FIELDS determines the columns to be displayed
in the detailed statistics. Possible columns are:
<ul>
<li>id => The x-th visitor since you've started counting</li>
<li>time => The time at which the last hit was registerred</li>
<li>visits => The hits of one unique visitor</li>
<li>dns => Visitor's hostname</li>
<li>ip => Visitor's IP address</li>
<li>os => The operating system (if available and/or no robot)</li>
<li>browser => The software used for establishing the connection</li>
<li>ext => Visitor's country or extension</li>
<li>referer => The link from which a visitor came (if available)</li>
<li>page => The last visited page</li>
<li>search => The search query a visitor used (if available)</li>
</ul>
The same order you've arranged the columns will be used for display.<br />
Examples:<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;id, time, visits, ip, ext, os, browser&quot;;
<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;date, ext, browser, os, ip&quot;;<br />",

"config_BBC_TIME_OFFSET" =>
"In case the server time doesn't match your local timezone, you can adjust the
time in minutes by using this switch. Negative values will set back the time,
positive ones will set it forth.<br />
Examples:<br />
\$BBC_TIME_OFFSET = 300;<br />
\$BBC_TIME_OFFSET = -300;<br />
\$BBC_TIME_OFFSET = 0;",

"config_BBC_NO_DNS" =>
"This options defines, whether IP addresses should be resolved to hostnames or
not. While hostnames tell a lot more about the visitor, resolving them may
considerably slow down your site, if the DNS servers used are slow, limited in
their capacity or otherwise unreliable. Setting this variable may solve the
problem.<br />
Examples:<br />
\$BBC_NO_DNS = 1;<br />
\$BBC_NO_DNS = &quot;&quot;;",

"config_BBC_NO_HITS" =>
"BBClone's default is to show hits in the time stats, because it gives a quite
useful Impression from the actual server load. If, however, you prefer to use
unique visits as base for your time stats, you can change the way of counting
by setting this variable.<br />
Examples:<br />
\$BBC_NO_HITS = 1;<br />
\$BBC_NO_HITS = &quot;&quot;;",

"config_BBC_IGNORE_IP" =>
"This option can be used to exclude particular IP addresses or address ranges
from counting. In case you want to add several expressions use a comma as
separator.<br />
Examples:<br />
\$BBC_IGNORE_IP = &quot;127., 192.168.&quot;;<br />
\$BBC_IGNORE_IP = &quot;&quot;;",

"config_BBC_IGNORE_REFER" =>
"In case you don't want to have particular referrers from your visitors listed
in your ranking or detailed stats, you can specify one or more keywords used
for blocking if a referrer matches up against them. If you use more keywords,
please use a comma as separator.<br />
Examples:<br />
\$BBC_IGNORE_REFER = &quot;spambot.org, .escort.&quot;;<br />
\$BBC_IGNORE_REFER = &quot;&quot;;",

"config_BBC_IGNORE_BOTS" =>
"You can use this option to determine the treatment of robots. The default is
to ignore them in the top hosts ranking but leave them in the remaining
stats. If you don't want to see any robots at all you can set this option to
&quot;2&quot;, then only human visits will be taken into account.<br />
Examples:<br />
\$BBC_IGNORE_BOTS = 2;<br />
\$BBC_IGNORE_BOTS = 1;<br />
\$BBC_IGNORE_BOTS = &quot;&quot;;",

"config_BBC_IGNORE_AGENT" =>
"This option defines how BBClone tells one visitor from another. Default is to
use the IP address only, which provides realistic figures in most cases. If,
however, your visitors often are hidden behind proxy servers, deactivation of
this option could provide more realistic figures, since a new visitor will be
assumed by the time the user agent has changed.<br />
Examples:<br />
\$BBC_IGNORE_AGENT = 1;<br />
\$BBC_IGNORE_AGENT = &quot;&quot;;",

"config_BBC_KILL_STATS" =>
"Whenever you wish to reset your stats you can activate this switch and have
them deleted by the next visit. Don't forget to deactivate it afterwards, else
you'll probably experience unusually low traffic ;).<br />
Examples:<br />
\$BBC_KILL_STATS = 1;<br />
\$BBC_KILL_STATS = &quot;&quot;;",

"config_BBC_PURGE_SINGLE" =>
"Host and referrer stats can generate a huge amount of data, however mostly
caused by one time visitors. By enabling this switch you can purge these
entries and considerably shrink access.php in its size without affecting your
actual visible host and referrer ranking. The amount of hits will be added to
the &quot;not_specified&quot; entries to keep the overall score intact.<br />
Examples:<br />
\$BBC_PURGE_SINGLE = 1;<br />
\$BBC_PURGE_SINGLE = &quot;&quot;;",

"config_BBC_LOADTIME" =>
"Generate the page load-time in seconds at bottom of the page.<br />
Examples:<br />
\$BBC_LOADTIME =&quot;&quot;;<br />
\$BBC_LOADTIME = 1;",

"config_BBC_EXT_LOOKUP" =>
"This options defines, whether IP addresses are looked up to determine location (country).<br />
These plug-ins are NO part of BBClone, please keep this in mind.<br />
<ul>
<li>IP2EXT => Use the old IP2EXT to Look-Up IP addresses</li>
<li>GEOIP => Use GeoIP API plug-in</li>
<li>GEOIP-mod => Use GeoIP PHP/Perl Module (geoip.so)</li>
</ul>
Examples:<br />
\$BBC_EXT_LOOKUP =&quot;&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;IP2EXT&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP-mod&quot;;",

"config_BBC_CSS_FILE" =>
"BBClone CSS File Name<br />
Please note; Within this css file you can change the way BBClone looks.<br />
(for example change colors or what text size/fonts are used)<br />
Examples:<br />
\$BBC_CSS_FILE =&quot;bbclone.css&quot;;<br />
\$BBC_CSS_FILE =&quot;other.css&quot;;",

"config_BBC_HITS" =>
"Include BBClone hits within the Stats<br />
Examples:<br />
\$BBC_HITS =1;<br />
\$BBC_HITS =&quot;&quot;;",

"config_BBC_USE_ORIGINAL_URI" =>
"Enable this option when the &quot;Top Visited Pages&quot; URI's are not working due
filtering of the URI. This can happen if you use BBClone with some Content
Management Systems (CMS) which are using very long (complex) URI naming.<br />
IMPORTED NOTE: This option changes how URI's are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_USE_ORIGINAL_URI = 1;	=> No filtering, use original URI<br />
\$BBC_USE_ORIGINAL_URI = &quot;&quot;;	=> Filter URI (default)",

"config_BBC_MAX_PAGENAME" =>
"The max. number of characters for the page name.<br />
Longer page names will be stript down at the front, leading with &quot;...&quot;<br />
IMPORTED NOTE: This option changes how page names are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_MAX_PAGENAME = 60;	=> 60 characters (default)"

);
?>
